/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.config.faces.handler;

import java.util.List;
import java.util.Map;
import org.seasar.teeda.core.config.faces.element.AttributeElement;
import org.seasar.teeda.core.config.faces.element.ComponentElement;
import org.seasar.teeda.core.config.faces.element.FacesConfig;
import org.seasar.teeda.core.config.faces.element.FacetElement;
import org.seasar.teeda.core.config.faces.element.PropertyElement;
import org.seasar.teeda.core.config.faces.element.impl.FacesConfigImpl;
import org.seasar.teeda.core.config.faces.handler.ComponentTagHandler;
import org.seasar.teeda.core.config.faces.handler.TagHandlerTestCase;
import org.seasar.teeda.core.mock.MockUIComponent;
import org.xml.sax.Attributes;

public class ComponentTagHandlerTest
extends TagHandlerTestCase {
    public ComponentTagHandlerTest(String name) {
        super(name);
    }

    public void testComponentTagHandler() throws Exception {
        FacesConfigImpl facesConfig = new FacesConfigImpl();
        this.getContext().push((Object)facesConfig);
        ComponentTagHandler handler = new ComponentTagHandler();
        handler.start(this.getContext(), (Attributes)new TagHandlerTestCase.NullAttributes());
        handler.end(this.getContext(), "a");
        Map components = facesConfig.getComponentElements();
        ComponentTagHandlerTest.assertNotNull((Object)components);
        ComponentTagHandlerTest.assertEquals((int)1, (int)components.entrySet().size());
        ComponentElement component = (ComponentElement)components.values().iterator().next();
        ComponentTagHandlerTest.assertNotNull((Object)component);
    }

    public void testComponentTagHandlerByXMLParse() throws Exception {
        FacesConfig facesConfig = this.parse("testComponentTagHandler.xml");
        Map map = facesConfig.getComponentElements();
        ComponentElement component = (ComponentElement)map.get("hoge");
        ComponentTagHandlerTest.assertEquals((String)"hoge", (String)component.getComponentType());
        ComponentTagHandlerTest.assertEquals((String)MockUIComponent.class.getName(), (String)component.getComponentClass());
        List facets = component.getFacetElements();
        ComponentTagHandlerTest.assertNotNull((Object)facets);
        ComponentTagHandlerTest.assertEquals((int)1, (int)facets.size());
        FacetElement facet = (FacetElement)facets.get(0);
        ComponentTagHandlerTest.assertEquals((String)"facet", (String)facet.getFacetName());
        List attributes = component.getAttributeElements();
        ComponentTagHandlerTest.assertNotNull((Object)attributes);
        ComponentTagHandlerTest.assertEquals((int)1, (int)attributes.size());
        AttributeElement attribute = (AttributeElement)attributes.get(0);
        ComponentTagHandlerTest.assertEquals((String)"attr", (String)attribute.getAttributeName());
        ComponentTagHandlerTest.assertEquals((String)"org.seasar.teeda.core.config.handler.Bean1", (String)attribute.getAttributeClass());
        List properties = component.getPropertyElements();
        ComponentTagHandlerTest.assertNotNull((Object)properties);
        ComponentTagHandlerTest.assertEquals((int)1, (int)properties.size());
        PropertyElement property = (PropertyElement)properties.get(0);
        ComponentTagHandlerTest.assertEquals((String)"id", (String)property.getPropertyName());
        ComponentTagHandlerTest.assertEquals((String)"String", (String)property.getPropertyClass());
        ComponentTagHandlerTest.assertEquals((String)"hoge", (String)property.getDefaultValue());
    }
}

