/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.config.faces.handler;

import java.util.List;
import java.util.Map;
import org.seasar.teeda.core.config.faces.element.AttributeElement;
import org.seasar.teeda.core.config.faces.element.AttributeHolder;
import org.seasar.teeda.core.config.faces.element.ComponentElement;
import org.seasar.teeda.core.config.faces.element.ConverterElement;
import org.seasar.teeda.core.config.faces.element.FacesConfig;
import org.seasar.teeda.core.config.faces.element.ValidatorElement;
import org.seasar.teeda.core.config.faces.element.impl.ComponentElementImpl;
import org.seasar.teeda.core.config.faces.handler.AttributeTagHandler;
import org.seasar.teeda.core.config.faces.handler.TagHandlerTestCase;
import org.xml.sax.Attributes;

public class AttributeTagHandlerTest
extends TagHandlerTestCase {
    public AttributeTagHandlerTest(String name) {
        super(name);
    }

    public void testAttributeTagHandler() throws Exception {
        AttributeTagHandler handler = new AttributeTagHandler();
        ComponentElementImpl holder = new ComponentElementImpl();
        this.getContext().push((Object)holder);
        handler.start(this.getContext(), (Attributes)new TagHandlerTestCase.NullAttributes());
        handler.end(this.getContext(), "body");
        AttributeTagHandlerTest.assertNotNull((Object)holder.getAttributeElements());
        AttributeTagHandlerTest.assertEquals((int)1, (int)holder.getAttributeElements().size());
        List list = holder.getAttributeElements();
        AttributeElement element = (AttributeElement)list.get(0);
        AttributeTagHandlerTest.assertNotNull((Object)element);
    }

    public void testAttributeTagHandlerByXMLParse() throws Exception {
        FacesConfig facesConfig = this.parse("testAttributeTagHandler.xml");
        Map components = facesConfig.getComponentElements();
        ComponentElement component = (ComponentElement)components.get("type");
        AttributeElement attribute = AttributeTagHandlerTest.getFirstAttribute((AttributeHolder)component);
        AttributeTagHandlerTest.assertNotNull((Object)attribute);
        AttributeTagHandlerTest.assertEquals((String)"hoge", (String)attribute.getAttributeName());
        AttributeTagHandlerTest.assertEquals((String)Hoge.class.getName(), (String)attribute.getAttributeClass());
        Map converters = facesConfig.getConverterElementsById();
        ConverterElement converter = (ConverterElement)converters.get("converter-id");
        attribute = AttributeTagHandlerTest.getFirstAttribute((AttributeHolder)converter);
        AttributeTagHandlerTest.assertNotNull((Object)attribute);
        AttributeTagHandlerTest.assertEquals((String)"foo", (String)attribute.getAttributeName());
        AttributeTagHandlerTest.assertEquals((String)Foo.class.getName(), (String)attribute.getAttributeClass());
        Map validators = facesConfig.getValidatorElements();
        ValidatorElement validator = (ValidatorElement)validators.get("validator-id");
        attribute = AttributeTagHandlerTest.getFirstAttribute((AttributeHolder)validator);
        AttributeTagHandlerTest.assertNotNull((Object)attribute);
        AttributeTagHandlerTest.assertEquals((String)"bar", (String)attribute.getAttributeName());
        AttributeTagHandlerTest.assertEquals((String)Bar.class.getName(), (String)attribute.getAttributeClass());
    }

    private static AttributeElement getFirstAttribute(AttributeHolder holder) {
        List attributes = holder.getAttributeElements();
        AttributeTagHandlerTest.assertNotNull((Object)attributes);
        AttributeTagHandlerTest.assertEquals((int)1, (int)attributes.size());
        AttributeElement attribute = (AttributeElement)attributes.get(0);
        return attribute;
    }

    public static class Bar {
    }

    public static class Foo {
    }

    public static class Hoge {
    }
}

