/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.config.faces.assembler.impl;

import java.util.ArrayList;
import java.util.Locale;
import org.seasar.teeda.core.config.faces.assembler.impl.DefaultApplicationAssembler;
import org.seasar.teeda.core.config.faces.element.LocaleConfigElement;
import org.seasar.teeda.core.config.faces.element.impl.ApplicationElementImpl;
import org.seasar.teeda.core.config.faces.element.impl.LocaleConfigElementImpl;
import org.seasar.teeda.core.mock.MockActionListener;
import org.seasar.teeda.core.mock.MockApplication;
import org.seasar.teeda.core.mock.MockNavigationHandler;
import org.seasar.teeda.core.mock.MockPropertyResolver;
import org.seasar.teeda.core.mock.MockStateManager;
import org.seasar.teeda.core.mock.MockVariableResolver;
import org.seasar.teeda.core.mock.MockViewHandlerImpl;
import org.seasar.teeda.core.unit.TeedaTestCase;

public class DefaultApplicationAssemblerTest
extends TeedaTestCase {
    public DefaultApplicationAssemblerTest(String name) {
        super(name);
    }

    public void testAssembleApplication() throws Exception {
        ApplicationElementImpl element = new ApplicationElementImpl();
        element.addActionListener("org.seasar.teeda.core.mock.MockActionListener");
        element.addDefaultRenderKitId("hoge");
        LocaleConfigElementImpl locale = new LocaleConfigElementImpl();
        locale.setDefaultLocale("en");
        locale.addSupportedLocale("ja");
        locale.addSupportedLocale("fr");
        element.addLocaleConfig((LocaleConfigElement)locale);
        element.addMessageBundle("foo");
        element.addNavigationHandler("org.seasar.teeda.core.mock.MockNavigationHandler");
        element.addPropertyResolver("org.seasar.teeda.core.mock.MockPropertyResolver");
        element.addStateManager("org.seasar.teeda.core.mock.MockStateManager");
        element.addVariableResolver("org.seasar.teeda.core.mock.MockVariableResolver");
        element.addViewHandler("org.seasar.teeda.core.mock.MockViewHandlerImpl");
        ArrayList<ApplicationElementImpl> list = new ArrayList<ApplicationElementImpl>();
        list.add(element);
        DefaultApplicationAssembler assembler = new DefaultApplicationAssembler(list);
        assembler.assemble();
        MockApplication app = this.getApplication();
        DefaultApplicationAssemblerTest.assertTrue((boolean)(app.getActionListener() instanceof MockActionListener));
        DefaultApplicationAssemblerTest.assertEquals((String)"hoge", (String)app.getDefaultRenderKitId());
        DefaultApplicationAssemblerTest.assertEquals((Object)Locale.ENGLISH, (Object)app.getDefaultLocale());
        DefaultApplicationAssemblerTest.assertEquals((String)"foo", (String)app.getMessageBundle());
        DefaultApplicationAssemblerTest.assertTrue((boolean)(app.getNavigationHandler() instanceof MockNavigationHandler));
        DefaultApplicationAssemblerTest.assertTrue((boolean)(app.getPropertyResolver() instanceof MockPropertyResolver));
        DefaultApplicationAssemblerTest.assertTrue((boolean)(app.getStateManager() instanceof MockStateManager));
        DefaultApplicationAssemblerTest.assertTrue((boolean)(app.getVariableResolver() instanceof MockVariableResolver));
        DefaultApplicationAssemblerTest.assertTrue((boolean)(app.getViewHandler() instanceof MockViewHandlerImpl));
    }
}

