/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.model;

import javax.faces.model.DataModel;
import javax.faces.model.DataModelListener;
import junit.framework.TestCase;
import org.seasar.teeda.core.mock.MockDataModelListener;

public class DataModelTest
extends TestCase {
    public void testAddModelListener() throws Exception {
        TargetDataModel model = new TargetDataModel();
        MockDataModelListener listener = new MockDataModelListener();
        model.addDataModelListener((DataModelListener)listener);
        DataModelListener[] listeners = model.getDataModelListeners();
        DataModelTest.assertEquals((Object)listener, (Object)listeners[0]);
        try {
            model.addDataModelListener(null);
            DataModelTest.fail();
        }
        catch (NullPointerException e) {
            DataModelTest.assertTrue((boolean)true);
        }
    }

    public void testGetDataModelListeners() throws Exception {
        TargetDataModel model = new TargetDataModel();
        model.addDataModelListener((DataModelListener)new MockDataModelListener("1"));
        model.addDataModelListener((DataModelListener)new MockDataModelListener("2"));
        DataModelListener[] listeners = model.getDataModelListeners();
        DataModelTest.assertEquals((String)"1", (String)listeners[0].toString());
        DataModelTest.assertEquals((String)"2", (String)listeners[1].toString());
    }

    public void testRemoveDataModelListeners() throws Exception {
        TargetDataModel model = new TargetDataModel();
        MockDataModelListener listener = new MockDataModelListener();
        model.addDataModelListener((DataModelListener)listener);
        model.removeDataModelListener((DataModelListener)listener);
        try {
            model.removeDataModelListener(null);
            DataModelTest.fail();
        }
        catch (NullPointerException e) {
            DataModelTest.assertTrue((boolean)true);
        }
    }

    private static class TargetDataModel
    extends DataModel {
        public int getRowCount() {
            return 0;
        }

        public Object getRowData() {
            return null;
        }

        public int getRowIndex() {
            return 0;
        }

        public Object getWrappedData() {
            return null;
        }

        public boolean isRowAvailable() {
            return false;
        }

        public void setRowIndex(int rowIndex) {
        }

        public void setWrappedData(Object data) {
        }
    }
}

