/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.convert.DateTimeConverter;
import javax.faces.internal.SerializableStateHolder;
import javax.faces.render.Renderer;
import junit.framework.TestCase;
import junitx.framework.ObjectAssert;
import org.seasar.teeda.core.mock.MockFacesContextImpl;
import org.seasar.teeda.core.mock.MockStateHolder;
import org.seasar.teeda.core.mock.MockUIComponentBase;
import org.seasar.teeda.core.mock.NullFacesContext;
import org.seasar.teeda.core.mock.NullRenderer;
import org.seasar.teeda.core.mock.NullUIComponent;
import org.seasar.teeda.core.unit.ExceptionAssert;

public class UIComponentBaseOnlyTest
extends TestCase {
    public void testGetRendersChildren() {
        final boolean[] calls = new boolean[]{false};
        MockUIComponentBase component = new MockUIComponentBase(){

            protected Renderer getRenderer(FacesContext context) {
                return new NullRenderer(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public boolean getRendersChildren() {
                        1.access$000(this.this$1)[0] = true;
                        return false;
                    }
                };
            }

            static /* synthetic */ boolean[] access$000(1 x0) {
                return x0.calls;
            }
        };
        component.setRendererType("foo");
        component.getRendersChildren();
        UIComponentBaseOnlyTest.assertEquals((boolean)true, (boolean)calls[0]);
    }

    public void testGetRendersChildren_NoRenderer() {
        MockUIComponentBase component = new MockUIComponentBase(){

            protected Renderer getRenderer(FacesContext context) {
                return null;
            }
        };
        UIComponentBaseOnlyTest.assertEquals((boolean)false, (boolean)component.getRendersChildren());
    }

    public void testEncodeBegin() throws Exception {
        final boolean[] calls = new boolean[]{false};
        MockUIComponentBase component = new MockUIComponentBase(){

            protected Renderer getRenderer(FacesContext context) {
                return new NullRenderer(this){
                    private final /* synthetic */ 4 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
                        4.access$100(this.this$1)[0] = true;
                    }
                };
            }

            static /* synthetic */ boolean[] access$100(4 x0) {
                return x0.calls;
            }
        };
        component.encodeBegin(new NullFacesContext());
        UIComponentBaseOnlyTest.assertEquals((boolean)true, (boolean)calls[0]);
    }

    public void testEncodeBegin_RenderFalse() throws Exception {
        final boolean[] calls = new boolean[]{false};
        MockUIComponentBase component = new MockUIComponentBase(){

            protected Renderer getRenderer(FacesContext context) {
                return new NullRenderer(this){
                    private final /* synthetic */ 6 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
                        6.access$200(this.this$1)[0] = true;
                    }
                };
            }

            static /* synthetic */ boolean[] access$200(6 x0) {
                return x0.calls;
            }
        };
        component.setRendered(false);
        component.encodeBegin(new NullFacesContext());
        UIComponentBaseOnlyTest.assertEquals((boolean)false, (boolean)calls[0]);
    }

    public void testEncodeChildren() throws Exception {
        final boolean[] calls = new boolean[]{false};
        MockUIComponentBase component = new MockUIComponentBase(){

            protected Renderer getRenderer(FacesContext context) {
                return new NullRenderer(this){
                    private final /* synthetic */ 8 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
                        8.access$300(this.this$1)[0] = true;
                    }
                };
            }

            static /* synthetic */ boolean[] access$300(8 x0) {
                return x0.calls;
            }
        };
        component.encodeChildren(new NullFacesContext());
        UIComponentBaseOnlyTest.assertEquals((boolean)true, (boolean)calls[0]);
    }

    public void testEncodeChildren_RenderFalse() throws Exception {
        final boolean[] calls = new boolean[]{false};
        MockUIComponentBase component = new MockUIComponentBase(){

            protected Renderer getRenderer(FacesContext context) {
                return new NullRenderer(this){
                    private final /* synthetic */ 10 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
                        10.access$400(this.this$1)[0] = true;
                    }
                };
            }

            static /* synthetic */ boolean[] access$400(10 x0) {
                return x0.calls;
            }
        };
        component.setRendered(false);
        component.encodeChildren(new NullFacesContext());
        UIComponentBaseOnlyTest.assertEquals((boolean)false, (boolean)calls[0]);
    }

    public void testEncodeEnd() throws Exception {
        final boolean[] calls = new boolean[]{false};
        MockUIComponentBase component = new MockUIComponentBase(){

            protected Renderer getRenderer(FacesContext context) {
                return new NullRenderer(this){
                    private final /* synthetic */ 12 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
                        12.access$500(this.this$1)[0] = true;
                    }
                };
            }

            static /* synthetic */ boolean[] access$500(12 x0) {
                return x0.calls;
            }
        };
        component.encodeEnd(new NullFacesContext());
        UIComponentBaseOnlyTest.assertEquals((boolean)true, (boolean)calls[0]);
    }

    public void testEncodeEnd_RenderFalse() throws Exception {
        final boolean[] calls = new boolean[]{false};
        MockUIComponentBase component = new MockUIComponentBase(){

            protected Renderer getRenderer(FacesContext context) {
                return new NullRenderer(this){
                    private final /* synthetic */ 14 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
                        14.access$600(this.this$1)[0] = true;
                    }
                };
            }

            static /* synthetic */ boolean[] access$600(14 x0) {
                return x0.calls;
            }
        };
        component.setRendered(false);
        component.encodeEnd(new NullFacesContext());
        UIComponentBaseOnlyTest.assertEquals((boolean)false, (boolean)calls[0]);
    }

    public void testProcessSaveState_CallSaveState() throws Exception {
        final ArrayList callSeq = new ArrayList();
        MockUIComponentBase component = new MockUIComponentBase(){

            public Object saveState(FacesContext context) {
                callSeq.add("2");
                return "aaa";
            }
        };
        component.getChildren().add(new NullUIComponent(){

            public Object processSaveState(FacesContext context) {
                callSeq.add("1");
                return "1";
            }
        });
        component.processSaveState(new NullFacesContext());
        UIComponentBaseOnlyTest.assertEquals((int)2, (int)callSeq.size());
        UIComponentBaseOnlyTest.assertEquals((Object)"1", callSeq.get(0));
        UIComponentBaseOnlyTest.assertEquals((Object)"2", callSeq.get(1));
    }

    public final void testSaveAttachedState_ContextIsNull() throws Exception {
        try {
            UIComponentBase.saveAttachedState(null, (Object)new Object());
            UIComponentBaseOnlyTest.fail();
        }
        catch (NullPointerException npe) {
            String message = npe.getMessage();
            UIComponentBaseOnlyTest.assertNotNull((Object)message);
            UIComponentBaseOnlyTest.assertTrue((message.trim().length() > 0 ? 1 : 0) != 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void testRestoreAttachedState_IllegalState() throws Exception {
        MockFacesContextImpl context = new MockFacesContextImpl();
        try {
            UIComponentBase.restoreAttachedState((FacesContext)context, (Object)new Object());
            UIComponentBaseOnlyTest.fail();
        }
        catch (IllegalStateException ise) {
            ExceptionAssert.assertMessageExist(ise);
        }
        finally {
            context.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSaveAndRestoreAttachedState_StateHolder1() {
        MockStateHolder holder = new MockStateHolder();
        holder.setValue("321");
        MockFacesContextImpl context = new MockFacesContextImpl();
        try {
            Object state = UIComponentBase.saveAttachedState((FacesContext)context, (Object)holder);
            ObjectAssert.assertInstanceOf((Class)Serializable.class, (Object)state);
            MockStateHolder restored = (MockStateHolder)UIComponentBase.restoreAttachedState((FacesContext)context, (Object)state);
            UIComponentBaseOnlyTest.assertEquals((Object)"321", (Object)restored.getValue());
        }
        finally {
            context.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSaveAndRestoreAttachedState_StateHolder2() {
        DateTimeConverter holder = new DateTimeConverter();
        holder.setTimeStyle("abc");
        MockFacesContextImpl context = new MockFacesContextImpl();
        try {
            Object state = UIComponentBase.saveAttachedState((FacesContext)context, (Object)holder);
            ObjectAssert.assertInstanceOf((Class)Serializable.class, (Object)state);
            DateTimeConverter restored = (DateTimeConverter)UIComponentBase.restoreAttachedState((FacesContext)context, (Object)state);
            UIComponentBaseOnlyTest.assertEquals((String)"abc", (String)restored.getTimeStyle());
        }
        finally {
            context.release();
        }
    }

    public void testProcessDecodes_CallFacetsAndChildren() throws Exception {
        final ArrayList callSeq = new ArrayList();
        MockUIComponentBase component = new MockUIComponentBase();
        component.getChildren().add(new NullUIComponent(){

            public void processDecodes(FacesContext context) {
                callSeq.add("1");
            }
        });
        component.getChildren().add(new NullUIComponent(){

            public void processDecodes(FacesContext context) {
                callSeq.add("2");
            }
        });
        component.getFacets().put("A", new NullUIComponent(){

            public void processDecodes(FacesContext context) {
                callSeq.add("3");
            }
        });
        component.getFacets().put("B", new NullUIComponent(){

            public void processDecodes(FacesContext context) {
                callSeq.add("4");
            }
        });
        component.getChildren().add(new NullUIComponent(){

            public void processDecodes(FacesContext context) {
                callSeq.add("5");
            }
        });
        component.processDecodes(new NullFacesContext());
        UIComponentBaseOnlyTest.assertEquals((int)5, (int)callSeq.size());
    }

    public void testProcessDecodes_RenderFalse() throws Exception {
        final ArrayList callSeq = new ArrayList();
        MockUIComponentBase component = new MockUIComponentBase();
        component.setRendered(false);
        component.getFacets().put("B", new NullUIComponent(){

            public void processDecodes(FacesContext context) {
                callSeq.add("4");
            }
        });
        component.getChildren().add(new NullUIComponent(){

            public void processDecodes(FacesContext context) {
                callSeq.add("5");
            }
        });
        component.processDecodes(new NullFacesContext());
        UIComponentBaseOnlyTest.assertEquals((int)0, (int)callSeq.size());
    }

    public final void testProcessDecodes_DecodeThrowsException_RenderResponseCalled() throws Exception {
        final boolean[] calls = new boolean[]{false};
        final RuntimeException runtimeException = new RuntimeException("for test");
        MockUIComponentBase component = new MockUIComponentBase(){

            public void decode(FacesContext context) {
                throw runtimeException;
            }
        };
        NullFacesContext context = new NullFacesContext(){

            public void renderResponse() {
                calls[0] = true;
            }
        };
        try {
            component.processDecodes(context);
            UIComponentBaseOnlyTest.fail();
        }
        catch (RuntimeException e) {
            UIComponentBaseOnlyTest.assertSame((Object)runtimeException, (Object)e);
        }
        UIComponentBaseOnlyTest.assertEquals((boolean)true, (boolean)calls[0]);
    }

    public void testProcessDecodes_CallDecode() throws Exception {
    }

    public void testProcessValidators_CallFacetsAndChildren() throws Exception {
        final ArrayList callSeq = new ArrayList();
        MockUIComponentBase component = new MockUIComponentBase();
        component.getChildren().add(new NullUIComponent(){

            public void processValidators(FacesContext context) {
                callSeq.add("1");
            }
        });
        component.getChildren().add(new NullUIComponent(){

            public void processValidators(FacesContext context) {
                callSeq.add("2");
            }
        });
        component.getFacets().put("A", new NullUIComponent(){

            public void processValidators(FacesContext context) {
                callSeq.add("3");
            }
        });
        component.getFacets().put("B", new NullUIComponent(){

            public void processValidators(FacesContext context) {
                callSeq.add("4");
            }
        });
        component.processValidators(new NullFacesContext());
        UIComponentBaseOnlyTest.assertEquals((int)4, (int)callSeq.size());
    }

    public void testProcessValidators_RenderFalse() throws Exception {
        final ArrayList callSeq = new ArrayList();
        MockUIComponentBase component = new MockUIComponentBase();
        component.setRendered(false);
        component.getChildren().add(new NullUIComponent(){

            public void processValidators(FacesContext context) {
                callSeq.add("1");
            }
        });
        component.getFacets().put("B", new NullUIComponent(){

            public void processValidators(FacesContext context) {
                callSeq.add("4");
            }
        });
        component.processValidators(new NullFacesContext());
        UIComponentBaseOnlyTest.assertEquals((int)0, (int)callSeq.size());
    }

    public void testProcessUpdates_CallFacetsAndChildren() throws Exception {
        final ArrayList callSeq = new ArrayList();
        MockUIComponentBase component = new MockUIComponentBase();
        component.getChildren().add(new NullUIComponent(){

            public void processUpdates(FacesContext context) {
                callSeq.add("1");
            }
        });
        component.getChildren().add(new NullUIComponent(){

            public void processUpdates(FacesContext context) {
                callSeq.add("2");
            }
        });
        component.getFacets().put("A", new NullUIComponent(){

            public void processUpdates(FacesContext context) {
                callSeq.add("3");
            }
        });
        component.getFacets().put("B", new NullUIComponent(){

            public void processUpdates(FacesContext context) {
                callSeq.add("4");
            }
        });
        component.processUpdates(new NullFacesContext());
        UIComponentBaseOnlyTest.assertEquals((int)4, (int)callSeq.size());
    }

    public void testProcessUpdates_RenderFalse() throws Exception {
        final ArrayList callSeq = new ArrayList();
        MockUIComponentBase component = new MockUIComponentBase();
        component.setRendered(false);
        component.getChildren().add(new NullUIComponent(){

            public void processUpdates(FacesContext context) {
                callSeq.add("1");
            }
        });
        component.getFacets().put("B", new NullUIComponent(){

            public void processUpdates(FacesContext context) {
                callSeq.add("4");
            }
        });
        component.processUpdates(new NullFacesContext());
        UIComponentBaseOnlyTest.assertEquals((int)0, (int)callSeq.size());
    }

    public void testProcessRestoreState() throws Exception {
        final ArrayList callSeq = new ArrayList();
        MockUIComponentBase component = new MockUIComponentBase(){

            public void restoreState(FacesContext context, Object state) {
                callSeq.add("5");
            }
        };
        component.getChildren().add(new NullUIComponent(){

            public void processRestoreState(FacesContext context, Object state) {
                callSeq.add("1");
            }
        });
        component.getChildren().add(new NullUIComponent(){

            public void processRestoreState(FacesContext context, Object state) {
                callSeq.add("2");
            }
        });
        component.getFacets().put("A", new NullUIComponent(){

            public void processRestoreState(FacesContext context, Object state) {
                callSeq.add("3");
            }
        });
        component.getFacets().put("B", new NullUIComponent(){

            public void processRestoreState(FacesContext context, Object state) {
                callSeq.add("4");
            }
        });
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("A", "a");
        m.put("B", "b");
        component.processRestoreState(new NullFacesContext(), new SerializableStateHolder(null, m, Arrays.asList("", "")));
        UIComponentBaseOnlyTest.assertEquals((int)5, (int)callSeq.size());
        UIComponentBaseOnlyTest.assertEquals((String)("last time, call self restoreState. " + ((Object)callSeq).toString()), (Object)"5", callSeq.get(4));
    }
}

