/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.render;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import javax.faces.internal.FacesConfigOptions;
import org.seasar.framework.util.Base64Util;
import org.seasar.framework.util.InputStreamUtil;
import org.seasar.framework.util.OutputStreamUtil;
import org.seasar.teeda.core.render.EncodeConverter;
import org.seasar.teeda.core.util.GZIPInputStreamUtil;
import org.seasar.teeda.core.util.GZIPOutputStreamUtil;
import org.seasar.teeda.core.util.ObjectInputStreamUtil;
import org.seasar.teeda.core.util.ObjectOutputStreamUtil;

public class Base64EncodeConverter
implements EncodeConverter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAsEncodeString(Object target) {
        String string;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        GZIPOutputStream gzipOut = null;
        ObjectOutputStream oos = null;
        try {
            if (this.isCompressRequested()) {
                gzipOut = GZIPOutputStreamUtil.getOutputStream(bos);
                oos = ObjectOutputStreamUtil.getOutputStream(gzipOut);
                ObjectOutputStreamUtil.writeObject(oos, target);
                GZIPOutputStreamUtil.finish(gzipOut);
            } else {
                oos = ObjectOutputStreamUtil.getOutputStream(bos);
                ObjectOutputStreamUtil.writeObject(oos, target);
            }
            string = Base64Util.encode((byte[])bos.toByteArray());
        }
        catch (Throwable throwable) {
            OutputStreamUtil.close(oos);
            OutputStreamUtil.close((OutputStream)gzipOut);
            OutputStreamUtil.close((OutputStream)bos);
            throw throwable;
        }
        OutputStreamUtil.close((OutputStream)oos);
        OutputStreamUtil.close((OutputStream)gzipOut);
        OutputStreamUtil.close((OutputStream)bos);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAsDecodeObject(String state) {
        Object object;
        byte[] bytes = Base64Util.decode((String)state);
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        InputStream is = null;
        ObjectInputStream ois = null;
        try {
            if (this.isCompressRequested()) {
                is = GZIPInputStreamUtil.getInputStream(bis);
                ois = ObjectInputStreamUtil.getInputStream(is);
            } else {
                ois = ObjectInputStreamUtil.getInputStream(bis);
            }
            object = ObjectInputStreamUtil.readObject(ois);
        }
        catch (Throwable throwable) {
            InputStreamUtil.close(ois);
            InputStreamUtil.close((InputStream)is);
            InputStreamUtil.close((InputStream)bis);
            throw throwable;
        }
        InputStreamUtil.close((InputStream)ois);
        InputStreamUtil.close((InputStream)is);
        InputStreamUtil.close((InputStream)bis);
        return object;
    }

    protected boolean isCompressRequested() {
        return FacesConfigOptions.getCompressState();
    }
}

