/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.util;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.seasar.teeda.core.mock.MockUIComponentBase;
import org.seasar.teeda.core.mock.MockUIComponentBaseWithNamingContainer;
import org.seasar.teeda.core.unit.TeedaTestCase;
import org.seasar.teeda.core.util.StateManagerUtil;

public class StateManagerUtilTest
extends TeedaTestCase {
    public void testIsSavingStateClient() throws Exception {
        StateManagerUtilTest.assertFalse((boolean)StateManagerUtil.isSavingStateInClient((FacesContext)this.getFacesContext()));
    }

    public void testAssertComponentNoDuplicateId_success() throws Exception {
        MockUIComponentBase parent = new MockUIComponentBase();
        parent.setId("id0");
        MockUIComponentBase child1 = new MockUIComponentBase();
        child1.setId("id1");
        parent.getChildren().add(child1);
        MockUIComponentBase child2 = new MockUIComponentBase();
        child2.setId("id2");
        parent.getFacets().put("hoge", child2);
        StateManagerUtil.assertComponentNoDuplicateId((UIComponent)parent);
        StateManagerUtilTest.assertTrue((boolean)true);
    }

    public void testAssertComponentNoDuplicateId_idDuplicate() throws Exception {
        MockUIComponentBase parent = new MockUIComponentBase();
        parent.setId("id0");
        MockUIComponentBase child1 = new MockUIComponentBase();
        child1.setId("id1");
        parent.getChildren().add(child1);
        MockUIComponentBase child2 = new MockUIComponentBase();
        child2.setId("id0");
        parent.getFacets().put("hoge", child2);
        try {
            StateManagerUtil.assertComponentNoDuplicateId((UIComponent)parent);
            StateManagerUtilTest.fail();
        }
        catch (IllegalStateException expected) {
            StateManagerUtilTest.success();
        }
    }

    public void testAssertComponentNoDuplicateId_idDuplicateWithNamingContainer() throws Exception {
        MockUIComponentBase parent = new MockUIComponentBase();
        parent.setId("id0");
        MockUIComponentBase child1 = new MockUIComponentBase();
        child1.setId("child1");
        parent.getChildren().add(child1);
        MockUIComponentBaseWithNamingContainer child2 = new MockUIComponentBaseWithNamingContainer();
        child2.setId("child2");
        MockUIComponentBase grandChild1 = new MockUIComponentBase();
        grandChild1.setId("grandchild1");
        child2.getChildren().add(grandChild1);
        MockUIComponentBase grandChild2 = new MockUIComponentBase();
        grandChild2.setId("grandchild1");
        grandChild1.getFacets().put("hoge", grandChild2);
        parent.getFacets().put("foo", child2);
        try {
            StateManagerUtil.assertComponentNoDuplicateId((UIComponent)parent);
            StateManagerUtilTest.fail();
        }
        catch (IllegalStateException expected) {
            StateManagerUtilTest.success();
        }
    }
}

