/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.unit;

import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.seasar.teeda.core.unit.ExceptionAssert;
import org.seasar.teeda.core.unit.ExceptionalClosure;

public class AssertUtilTest
extends TestCase {
    public void testAssertThrows_FailNoThrown() throws Exception {
        try {
            ExceptionAssert.assertThrows(NullPointerException.class, new ExceptionalClosure(){

                public void execute() throws Throwable {
                }
            });
            AssertUtilTest.fail();
        }
        catch (AssertionFailedError assertionFailedError) {
            // empty catch block
        }
    }

    public void testAssertThrows_FailAnotherThrown() throws Exception {
        try {
            ExceptionAssert.assertThrows(NullPointerException.class, new ExceptionalClosure(){

                public void execute() throws Throwable {
                    throw new IllegalStateException("for test");
                }
            });
            AssertUtilTest.fail();
        }
        catch (AssertionFailedError assertionFailedError) {
            // empty catch block
        }
    }

    public void testAssertExceptionMessageExist_Success() throws Exception {
        ExceptionAssert.assertMessageExist(new NullPointerException("c"));
    }

    public void testAssertExceptionMessageExist_Fail() throws Exception {
        ExceptionAssert.assertThrows(AssertionFailedError.class, new ExceptionalClosure(){

            public void execute() {
                ExceptionAssert.assertMessageExist(new NullPointerException());
            }
        });
    }

    public void testAssertNotEquals_Success() throws Exception {
        ExceptionAssert.assertNotEquals("a", "b");
        ExceptionAssert.assertNotEquals(null, "b");
        ExceptionAssert.assertNotEquals("a", null);
    }

    public void testAssertNotEquals_Fail() throws Exception {
        ExceptionAssert.assertThrows(AssertionFailedError.class, new ExceptionalClosure(){

            public void execute() {
                ExceptionAssert.assertNotEquals("a", "a");
            }
        });
        ExceptionAssert.assertThrows(AssertionFailedError.class, new ExceptionalClosure(){

            public void execute() {
                ExceptionAssert.assertNotEquals(null, null);
            }
        });
    }
}

