/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.taglib.core;

import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.validator.LongRangeValidator;
import javax.faces.validator.Validator;
import org.seasar.teeda.core.mock.MockApplication;
import org.seasar.teeda.core.mock.MockApplicationImpl;
import org.seasar.teeda.core.mock.MockValueBinding;
import org.seasar.teeda.core.taglib.core.ValidateLongRangeTag;
import org.seasar.teeda.core.unit.TeedaTestCase;

public class ValidateLongRangeTagTest
extends TeedaTestCase {
    public void testCreateValidator() throws Exception {
        String validatorId = "javax.faces.LongRange";
        String validatorClassName = "javax.faces.validator.LongRangeValidator";
        MockApplicationImpl app = new MockApplicationImpl();
        app.addValidator(validatorId, validatorClassName);
        this.setApplication((MockApplication)app);
        ValidateLongRangeTag tag = new ValidateLongRangeTag();
        Validator validator = tag.createValidator();
        ValidateLongRangeTagTest.assertNotNull((Object)validator);
        ValidateLongRangeTagTest.assertTrue((boolean)(validator instanceof LongRangeValidator));
    }

    public void testCreateValidator_NotAddValidator() throws Exception {
        ValidateLongRangeTag tag = new ValidateLongRangeTag();
        try {
            tag.createValidator();
            ValidateLongRangeTagTest.fail();
        }
        catch (NullPointerException e) {
            ValidateLongRangeTagTest.success();
        }
    }

    public void testCreateValidator_noSetProperty() throws Exception {
        this.addValidator();
        ValidateLongRangeTag tag = new ValidateLongRangeTag();
        tag.createValidator();
        ValidateLongRangeTagTest.assertFalse((boolean)tag.isMinimumSet());
        ValidateLongRangeTagTest.assertFalse((boolean)tag.isMaximumSet());
    }

    public void testSetMinimum_constantValue() throws Exception {
        this.addValidator();
        ValidateLongRangeTag tag = new ValidateLongRangeTag();
        tag.setMinimum("2");
        LongRangeValidator validator = (LongRangeValidator)tag.createValidator();
        ValidateLongRangeTagTest.assertTrue((boolean)tag.isMinimumSet());
        ValidateLongRangeTagTest.assertTrue((2L == validator.getMinimum() ? 1 : 0) != 0);
    }

    public void testSetMinimum_bindingValue() throws Exception {
        this.addValidator();
        MockValueBinding vb = new MockValueBinding();
        vb.setValue((FacesContext)this.getFacesContext(), (Object)new Long(3L));
        this.getApplication().setValueBinding((ValueBinding)vb);
        ValidateLongRangeTag tag = new ValidateLongRangeTag();
        tag.setMinimum("#{hoge.minimum}");
        LongRangeValidator validator = (LongRangeValidator)tag.createValidator();
        ValidateLongRangeTagTest.assertTrue((boolean)tag.isMinimumSet());
        ValidateLongRangeTagTest.assertTrue((3L == validator.getMinimum() ? 1 : 0) != 0);
    }

    public void testSetMaximum_constantValue() throws Exception {
        this.addValidator();
        ValidateLongRangeTag tag = new ValidateLongRangeTag();
        tag.setMaximum("888888888888");
        LongRangeValidator validator = (LongRangeValidator)tag.createValidator();
        ValidateLongRangeTagTest.assertTrue((boolean)tag.isMaximumSet());
        ValidateLongRangeTagTest.assertTrue((888888888888L == validator.getMaximum() ? 1 : 0) != 0);
    }

    public void testSetMaximum_bindingValue() throws Exception {
        this.addValidator();
        MockValueBinding vb = new MockValueBinding();
        vb.setValue((FacesContext)this.getFacesContext(), (Object)new Long(9999999999L));
        this.getApplication().setValueBinding((ValueBinding)vb);
        ValidateLongRangeTag tag = new ValidateLongRangeTag();
        tag.setMaximum("#{hoge.maximum}");
        LongRangeValidator validator = (LongRangeValidator)tag.createValidator();
        ValidateLongRangeTagTest.assertTrue((boolean)tag.isMaximumSet());
        ValidateLongRangeTagTest.assertTrue((9999999999L == validator.getMaximum() ? 1 : 0) != 0);
    }

    private void addValidator() throws Exception {
        MockApplicationImpl app = new MockApplicationImpl();
        app.addValidator("javax.faces.LongRange", "javax.faces.validator.LongRangeValidator");
        this.setApplication((MockApplication)app);
    }
}

