/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.render.html.support;

import junit.framework.TestCase;
import org.seasar.teeda.core.render.html.support.UrlBuilder;
import org.seasar.teeda.core.unit.UrlDiff;

public class UrlBuilderTest
extends TestCase {
    public void testBase() throws Exception {
        UrlBuilder urlBuilder = new UrlBuilder();
        urlBuilder.setBase("a");
        UrlBuilderTest.assertEquals((String)"a", (String)urlBuilder.build());
    }

    public void testBuildWithParams() throws Exception {
        UrlBuilder urlBuilder = new UrlBuilder();
        urlBuilder.setBase("a");
        urlBuilder.add("1", "2");
        urlBuilder.add("3", "4");
        String actual = urlBuilder.build();
        System.out.println(actual);
        UrlDiff urlDiff = new UrlDiff("a?1=2&3=4", actual);
        UrlBuilderTest.assertEquals((String)actual, (boolean)true, (boolean)urlDiff.isIdentical());
    }

    public void testBuildWithParamsSpecifyDelim() throws Exception {
        UrlBuilder urlBuilder = new UrlBuilder();
        urlBuilder.setBase("a");
        urlBuilder.setParameterDelimiter("&amp;");
        urlBuilder.add("1", "2");
        urlBuilder.add("3", "4");
        String actual = urlBuilder.build();
        System.out.println(actual);
        UrlDiff urlDiff = new UrlDiff("a?1=2&amp;3=4", actual);
        UrlBuilderTest.assertEquals((String)actual, (boolean)true, (boolean)urlDiff.isIdentical());
    }

    public void testBuildWithQueryString() throws Exception {
        UrlBuilder urlBuilder = new UrlBuilder();
        urlBuilder.setBase("?b=c");
        urlBuilder.add("1", "2");
        urlBuilder.add("3", "4");
        String actual = urlBuilder.build();
        System.out.println(actual);
        UrlDiff urlDiff = new UrlDiff("?b=c&1=2&3=4", actual);
        UrlBuilderTest.assertEquals((String)actual, (boolean)true, (boolean)urlDiff.isIdentical());
    }

    public void testBuildWithParamsAndQueryString() throws Exception {
        UrlBuilder urlBuilder = new UrlBuilder();
        urlBuilder.setBase("a?b=c");
        urlBuilder.add("1", "2");
        urlBuilder.add("3", "4");
        String actual = urlBuilder.build();
        System.out.println(actual);
        UrlBuilderTest.assertEquals((String)"a?b=c&1=2&3=4", (String)actual);
    }

    public void testBuildWithParamsAndQueryStringAndFragment() throws Exception {
        UrlBuilder urlBuilder = new UrlBuilder();
        urlBuilder.setBase("a?b=c#fff");
        urlBuilder.add("1", "2");
        urlBuilder.add("3", "4");
        String actual = urlBuilder.build();
        System.out.println(actual);
        UrlBuilderTest.assertEquals((String)"a?b=c&1=2&3=4#fff", (String)actual);
    }

    public void testBuildWithParams_SameKey() throws Exception {
        UrlBuilder urlBuilder = new UrlBuilder();
        urlBuilder.setBase("a");
        urlBuilder.add("1", "2");
        urlBuilder.add("1", "4");
        String actual = urlBuilder.build();
        System.out.println(actual);
        UrlDiff urlDiff = new UrlDiff("a?1=2&1=4", actual);
        UrlBuilderTest.assertEquals((String)actual, (boolean)true, (boolean)urlDiff.isIdentical());
    }

    public void testBuildContainsPort() throws Exception {
        UrlBuilder urlBuilder = new UrlBuilder();
        urlBuilder.setBase("http://foohost:9901/a.html");
        urlBuilder.add("1", "2");
        String actual = urlBuilder.build();
        System.out.println(actual);
        UrlBuilderTest.assertEquals((String)"http://foohost:9901/a.html?1=2", (String)actual);
    }

    public void testBuildContainsUserInfo() throws Exception {
        UrlBuilder urlBuilder = new UrlBuilder();
        urlBuilder.setBase("http://user-info@foohost/a.html");
        urlBuilder.add("1", "2");
        String actual = urlBuilder.build();
        System.out.println(actual);
        UrlBuilderTest.assertEquals((String)"http://user-info@foohost/a.html?1=2", (String)actual);
    }

    public void testBuildContainsUserInfoAndPort() throws Exception {
        UrlBuilder urlBuilder = new UrlBuilder();
        urlBuilder.setBase("http://user-info@foohost:9901/a.html");
        urlBuilder.add("1", "2");
        String actual = urlBuilder.build();
        System.out.println(actual);
        UrlBuilderTest.assertEquals((String)"http://user-info@foohost:9901/a.html?1=2", (String)actual);
    }

    public void testBuildFullUrl() throws Exception {
        UrlBuilder urlBuilder = new UrlBuilder();
        urlBuilder.setBase("http://aaaa.bbb/cc/d.html#ee");
        urlBuilder.add("1", "2");
        urlBuilder.add("1", "4");
        String actual = urlBuilder.build();
        System.out.println(actual);
        UrlDiff urlDiff = new UrlDiff("http://aaaa.bbb/cc/d.html?1=2&1=4#ee", actual);
        UrlBuilderTest.assertEquals((String)actual, (boolean)true, (boolean)urlDiff.isIdentical());
    }

    public void testBuildMailTo() throws Exception {
        UrlBuilder urlBuilder = new UrlBuilder();
        urlBuilder.setBase("mailto:test@test.com");
        String actual = urlBuilder.build();
        UrlDiff urlDiff = new UrlDiff("mailto:test@test.com", actual);
        UrlBuilderTest.assertEquals((String)actual, (boolean)true, (boolean)urlDiff.isIdentical());
    }

    public void testBuildNews() throws Exception {
        UrlBuilder urlBuilder = new UrlBuilder();
        urlBuilder.setBase("news:comp.lang.java");
        String actual = urlBuilder.build();
        UrlDiff urlDiff = new UrlDiff("news:comp.lang.java", actual);
        UrlBuilderTest.assertEquals((String)actual, (boolean)true, (boolean)urlDiff.isIdentical());
    }

    public void testBuildUrn() throws Exception {
        UrlBuilder urlBuilder = new UrlBuilder();
        urlBuilder.setBase("urn:isbn:096139210x");
        String actual = urlBuilder.build();
        UrlDiff urlDiff = new UrlDiff("urn:isbn:096139210x", actual);
        UrlBuilderTest.assertEquals((String)actual, (boolean)true, (boolean)urlDiff.isIdentical());
    }
}

