/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.render.html;

import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectItem;
import javax.faces.component.UISelectItems;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;
import javax.faces.render.Renderer;
import javax.faces.render.RendererTest;
import org.custommonkey.xmlunit.Diff;
import org.seasar.framework.mock.servlet.MockHttpServletRequest;
import org.seasar.teeda.core.mock.MockFacesContext;
import org.seasar.teeda.core.mock.MockHtmlSelectOneListbox;
import org.seasar.teeda.core.mock.MockValueBinding;
import org.seasar.teeda.core.render.html.HtmlSelectOneListboxRenderer;
import org.seasar.teeda.core.util.PostbackUtil;

public class HtmlSelectOneListboxRendererTest
extends RendererTest {
    private HtmlSelectOneListboxRenderer renderer;
    private MockHtmlSelectOneListbox htmlSelectOneListbox;

    protected void setUp() throws Exception {
        super.setUp();
        this.renderer = this.createHtmlSelectOneListboxRenderer();
        this.htmlSelectOneListbox = new MockHtmlSelectOneListbox();
        this.htmlSelectOneListbox.setRenderer((Renderer)this.renderer);
        this.renderer.addIgnoreAttributeName("setSubmittedValueCalls");
    }

    public void testEncode_NoChild() throws Exception {
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectOneListbox);
        HtmlSelectOneListboxRendererTest.assertEquals((String)"", (String)this.getResponseText());
    }

    public void testEncode_RenderFalse() throws Exception {
        this.htmlSelectOneListbox.setRendered(false);
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"val");
        selectItem.setItemLabel("lab");
        this.htmlSelectOneListbox.getChildren().add(selectItem);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectOneListbox);
        HtmlSelectOneListboxRendererTest.assertEquals((String)"", (String)this.getResponseText());
    }

    public void testEncode_Child() throws Exception {
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"v");
        selectItem.setItemLabel("l");
        this.htmlSelectOneListbox.getChildren().add(selectItem);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectOneListbox);
        HtmlSelectOneListboxRendererTest.assertEquals((String)"<select name=\"_id0\" size=\"1\"><option value=\"v\">l</option></select>", (String)this.getResponseText());
    }

    public void testEncode_Id() throws Exception {
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"val");
        selectItem.setItemLabel("lab");
        this.htmlSelectOneListbox.getChildren().add(selectItem);
        this.htmlSelectOneListbox.setId("a");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectOneListbox);
        HtmlSelectOneListboxRendererTest.assertEquals((String)"<select id=\"a\" name=\"a\" size=\"1\"><option value=\"val\">lab</option></select>", (String)this.getResponseText());
    }

    public void testEncode_WithUnknownAttribute1() throws Exception {
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"val");
        selectItem.setItemLabel("lab");
        this.htmlSelectOneListbox.getChildren().add(selectItem);
        this.htmlSelectOneListbox.setId("a");
        this.htmlSelectOneListbox.getAttributes().put("bb", "cc");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectOneListbox);
        HtmlSelectOneListboxRendererTest.assertEquals((String)"<select id=\"a\" name=\"a\" size=\"1\" bb=\"cc\"><option value=\"val\">lab</option></select>", (String)this.getResponseText());
    }

    public void testEncode_WithUnknownAttribute2() throws Exception {
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"val");
        selectItem.setItemLabel("lab");
        this.htmlSelectOneListbox.getChildren().add(selectItem);
        this.htmlSelectOneListbox.setId("a");
        this.htmlSelectOneListbox.getAttributes().put("b.b", "cc");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectOneListbox);
        HtmlSelectOneListboxRendererTest.assertEquals((String)"<select id=\"a\" name=\"a\" size=\"1\"><option value=\"val\">lab</option></select>", (String)this.getResponseText());
    }

    public void testEncode_Children() throws Exception {
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"v1");
        selectItem.setItemLabel("l1");
        this.htmlSelectOneListbox.getChildren().add(selectItem);
        selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"v2");
        selectItem.setItemLabel("l2");
        this.htmlSelectOneListbox.getChildren().add(selectItem);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectOneListbox);
        HtmlSelectOneListboxRendererTest.assertEquals((String)"<select name=\"_id0\" size=\"2\"><option value=\"v1\">l1</option><option value=\"v2\">l2</option></select>", (String)this.getResponseText());
    }

    public void testEncode_Size() throws Exception {
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"v1");
        selectItem.setItemLabel("l1");
        this.htmlSelectOneListbox.getChildren().add(selectItem);
        this.htmlSelectOneListbox.setSize(6);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectOneListbox);
        HtmlSelectOneListboxRendererTest.assertEquals((String)"<select name=\"_id0\" size=\"6\"><option value=\"v1\">l1</option></select>", (String)this.getResponseText());
    }

    public void testEncode_SelectedIfPostbacked() throws Exception {
        PostbackUtil.setPostback((Map)this.getFacesContext().getExternalContext().getRequestMap(), (boolean)true);
        this.htmlSelectOneListbox.setValue("v2");
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"v1");
        selectItem.setItemLabel("l1");
        this.htmlSelectOneListbox.getChildren().add(selectItem);
        selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"v2");
        selectItem.setItemLabel("l2");
        this.htmlSelectOneListbox.getChildren().add(selectItem);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectOneListbox);
        HtmlSelectOneListboxRendererTest.assertEquals((String)"<select name=\"_id0\" size=\"2\"><option value=\"v1\">l1</option><option value=\"v2\" selected=\"selected\">l2</option></select>", (String)this.getResponseText());
    }

    public void testEncode_Selected_noValueBinding() throws Exception {
        this.htmlSelectOneListbox.setValue("2");
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"1");
        selectItem.setItemLabel("l1");
        this.htmlSelectOneListbox.getChildren().add(selectItem);
        selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"2");
        selectItem.setItemLabel("l2");
        this.htmlSelectOneListbox.getChildren().add(selectItem);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectOneListbox);
        HtmlSelectOneListboxRendererTest.assertEquals((String)"<select name=\"_id0\" size=\"2\"><option value=\"1\">l1</option><option value=\"2\" selected=\"selected\">l2</option></select>", (String)this.getResponseText());
    }

    public void testEncode_Selected_targetIsPrimitive() throws Exception {
        MockValueBinding vb = new MockValueBinding();
        vb.setValue((FacesContext)this.getFacesContext(), (Object)new Integer(2));
        vb.setType(Integer.TYPE);
        this.htmlSelectOneListbox.setValue("2");
        this.htmlSelectOneListbox.setValueBinding("value", (ValueBinding)vb);
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"1");
        selectItem.setItemLabel("l1");
        this.htmlSelectOneListbox.getChildren().add(selectItem);
        selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"2");
        selectItem.setItemLabel("l2");
        this.htmlSelectOneListbox.getChildren().add(selectItem);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectOneListbox);
        HtmlSelectOneListboxRendererTest.assertEquals((String)"<select name=\"_id0\" size=\"2\"><option value=\"1\">l1</option><option value=\"2\" selected=\"selected\">l2</option></select>", (String)this.getResponseText());
    }

    public void testEncode_Selected_primitiveZeroIgnored() throws Exception {
        MockValueBinding vb = new MockValueBinding();
        vb.setValue((FacesContext)this.getFacesContext(), (Object)new Integer(0));
        vb.setType(Integer.TYPE);
        this.htmlSelectOneListbox.setValue("0");
        this.htmlSelectOneListbox.setValueBinding("value", (ValueBinding)vb);
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"0");
        selectItem.setItemLabel("l1");
        this.htmlSelectOneListbox.getChildren().add(selectItem);
        selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"1");
        selectItem.setItemLabel("l2");
        this.htmlSelectOneListbox.getChildren().add(selectItem);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectOneListbox);
        HtmlSelectOneListboxRendererTest.assertEquals((String)"<select name=\"_id0\" size=\"2\"><option value=\"0\">l1</option><option value=\"1\">l2</option></select>", (String)this.getResponseText());
    }

    public void testEncode_SelectedIfInitialized() throws Exception {
        MockValueBinding vb = new MockValueBinding();
        vb.setValue((FacesContext)this.getFacesContext(), (Object)"2");
        vb.setType(Integer.class);
        this.htmlSelectOneListbox.setValue("2");
        this.htmlSelectOneListbox.setValueBinding("value", (ValueBinding)vb);
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"1");
        selectItem.setItemLabel("l1");
        this.htmlSelectOneListbox.getChildren().add(selectItem);
        selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"2");
        selectItem.setItemLabel("l2");
        this.htmlSelectOneListbox.getChildren().add(selectItem);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectOneListbox);
        HtmlSelectOneListboxRendererTest.assertEquals((String)"<select name=\"_id0\" size=\"2\"><option value=\"1\">l1</option><option value=\"2\" selected=\"selected\">l2</option></select>", (String)this.getResponseText());
    }

    public void testEncode_ItemDisabled() throws Exception {
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"v1");
        selectItem.setItemLabel("l1");
        selectItem.setItemDisabled(true);
        this.htmlSelectOneListbox.getChildren().add(selectItem);
        selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"v2");
        selectItem.setItemLabel("l2");
        this.htmlSelectOneListbox.getChildren().add(selectItem);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectOneListbox);
        HtmlSelectOneListboxRendererTest.assertEquals((String)"<select name=\"_id0\" size=\"2\"><option value=\"v1\" disabled=\"disabled\">l1</option><option value=\"v2\">l2</option></select>", (String)this.getResponseText());
    }

    public void testEncode_Disabled() throws Exception {
        this.htmlSelectOneListbox.setDisabled(true);
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"v1");
        selectItem.setItemLabel("l1");
        selectItem.setItemDisabled(true);
        this.htmlSelectOneListbox.getChildren().add(selectItem);
        selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"v2");
        selectItem.setItemLabel("l2");
        this.htmlSelectOneListbox.getChildren().add(selectItem);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectOneListbox);
        HtmlSelectOneListboxRendererTest.assertEquals((String)"<select name=\"_id0\" size=\"2\" disabled=\"disabled\"><option value=\"v1\" disabled=\"disabled\">l1</option><option value=\"v2\">l2</option></select>", (String)this.getResponseText());
    }

    public void testEncode_LabelClass() throws Exception {
        this.htmlSelectOneListbox.setEnabledClass("ec");
        this.htmlSelectOneListbox.setDisabledClass("dc");
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"v1");
        selectItem.setItemLabel("l1");
        this.htmlSelectOneListbox.getChildren().add(selectItem);
        selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"v2");
        selectItem.setItemLabel("l2");
        selectItem.setItemDisabled(true);
        this.htmlSelectOneListbox.getChildren().add(selectItem);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectOneListbox);
        HtmlSelectOneListboxRendererTest.assertEquals((String)"<select name=\"_id0\" size=\"2\"><option value=\"v1\" class=\"ec\">l1</option><option value=\"v2\" class=\"dc\" disabled=\"disabled\">l2</option></select>", (String)this.getResponseText());
    }

    public void testEncode_GroupChildren() throws Exception {
        UISelectItems selectItems = new UISelectItems();
        SelectItem item1 = new SelectItem((Object)"v1", "l1");
        SelectItem item2 = new SelectItem((Object)"v2", "l2", null, true);
        selectItems.setValue((Object)new SelectItem[]{item1, item2});
        this.htmlSelectOneListbox.getChildren().add(selectItems);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectOneListbox);
        HtmlSelectOneListboxRendererTest.assertEquals((String)"<select name=\"_id0\" size=\"2\"><option value=\"v1\">l1</option><option value=\"v2\" disabled=\"disabled\">l2</option></select>", (String)this.getResponseText());
    }

    public void testEncode_Optgroup() throws Exception {
        SelectItem item1 = new SelectItem((Object)"v1", "l1");
        SelectItem item2 = new SelectItem((Object)"v2", "l2", null, true);
        SelectItemGroup group = new SelectItemGroup("gl");
        group.setSelectItems(new SelectItem[]{item1, item2});
        UISelectItem selectItem = new UISelectItem();
        selectItem.setValue((Object)group);
        this.htmlSelectOneListbox.getChildren().add(selectItem);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectOneListbox);
        HtmlSelectOneListboxRendererTest.assertEquals((String)"<select name=\"_id0\" size=\"3\"><optgroup label=\"gl\"><option value=\"v1\">l1</option><option value=\"v2\" disabled=\"disabled\">l2</option></optgroup></select>", (String)this.getResponseText());
    }

    public void testEncode_WithAllAttributes() throws Exception {
        PostbackUtil.setPostback((Map)this.getFacesContext().getExternalContext().getRequestMap(), (boolean)true);
        this.htmlSelectOneListbox.setAccesskey("a");
        this.htmlSelectOneListbox.setDir("b");
        this.htmlSelectOneListbox.setDisabled(true);
        this.htmlSelectOneListbox.setDisabledClass("d");
        this.htmlSelectOneListbox.setEnabledClass("e");
        this.htmlSelectOneListbox.setLang("f");
        this.htmlSelectOneListbox.setOnblur("g");
        this.htmlSelectOneListbox.setOnchange("h");
        this.htmlSelectOneListbox.setOnclick("i");
        this.htmlSelectOneListbox.setOndblclick("j");
        this.htmlSelectOneListbox.setOnfocus("k");
        this.htmlSelectOneListbox.setOnkeydown("l");
        this.htmlSelectOneListbox.setOnkeypress("m");
        this.htmlSelectOneListbox.setOnkeyup("n");
        this.htmlSelectOneListbox.setOnmousedown("o");
        this.htmlSelectOneListbox.setOnmousemove("p");
        this.htmlSelectOneListbox.setOnmouseout("q");
        this.htmlSelectOneListbox.setOnmouseover("r");
        this.htmlSelectOneListbox.setOnmouseup("s");
        this.htmlSelectOneListbox.setOnselect("t");
        this.htmlSelectOneListbox.setReadonly(true);
        this.htmlSelectOneListbox.setSize(4);
        this.htmlSelectOneListbox.setStyle("w");
        this.htmlSelectOneListbox.setStyleClass("u");
        this.htmlSelectOneListbox.setTabindex("x");
        this.htmlSelectOneListbox.setTitle("y");
        this.htmlSelectOneListbox.getAttributes().put("name", "hoge");
        this.htmlSelectOneListbox.setId("A");
        this.htmlSelectOneListbox.setValue("val");
        this.htmlSelectOneListbox.setSubmittedValue("val");
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"val");
        selectItem.setItemLabel("lab");
        selectItem.getAttributes().put("selected", "selected");
        this.htmlSelectOneListbox.getChildren().add(selectItem);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectOneListbox);
        System.out.println(this.getResponseText());
        Diff diff = new Diff("<select id=\"A\" name=\"A\" size=\"4\" style=\"w\" class=\"u\" accesskey=\"a\" dir=\"b\" disabled=\"disabled\" lang=\"f\" onblur=\"g\" onchange=\"h\" onclick=\"i\" ondblclick=\"j\" onfocus=\"k\" onkeydown=\"l\" onkeypress=\"m\" onkeyup=\"n\" onmousedown=\"o\" onmousemove=\"p\" onmouseout=\"q\" onmouseover=\"r\" onmouseup=\"s\" onselect=\"t\" readonly=\"readonly\" tabindex=\"x\" title=\"y\"><option value=\"val\" class=\"d\" selected=\"selected\">lab</option></select>", this.getResponseText());
        HtmlSelectOneListboxRendererTest.assertEquals((String)diff.toString(), (boolean)true, (boolean)diff.identical());
    }

    public void testDecode_RequestParameterNotExist() throws Exception {
        this.htmlSelectOneListbox.setClientId("key");
        MockFacesContext context = this.getFacesContext();
        this.renderer.decode((FacesContext)context, (UIComponent)this.htmlSelectOneListbox);
        HtmlSelectOneListboxRendererTest.assertEquals((int)0, (int)this.htmlSelectOneListbox.getSetSubmittedValueCalls());
        HtmlSelectOneListboxRendererTest.assertEquals(null, (Object)this.htmlSelectOneListbox.getSubmittedValue());
    }

    public void testDecodeSuccess() throws Exception {
        this.htmlSelectOneListbox.setClientId("keyA");
        MockFacesContext context = this.getFacesContext();
        MockHttpServletRequest mockHttpServletRequest = context.getMockExternalContext().getMockHttpServletRequest();
        mockHttpServletRequest.addParameter("keyA", new String[]{"a"});
        this.renderer.decode((FacesContext)context, (UIComponent)this.htmlSelectOneListbox);
        HtmlSelectOneListboxRendererTest.assertEquals((int)1, (int)this.htmlSelectOneListbox.getSetSubmittedValueCalls());
        HtmlSelectOneListboxRendererTest.assertEquals((Object)"a", (Object)this.htmlSelectOneListbox.getSubmittedValue());
    }

    public void testGetRendersChildren() throws Exception {
        HtmlSelectOneListboxRendererTest.assertEquals((boolean)false, (boolean)this.renderer.getRendersChildren());
    }

    public void testGetConvertedValue() throws Exception {
        HtmlSelectOneListboxRendererTest.assertEquals((Object)"hoge", (Object)this.renderer.getConvertedValue((FacesContext)this.getFacesContext(), (UIComponent)this.htmlSelectOneListbox, (Object)"hoge"));
    }

    private HtmlSelectOneListboxRenderer createHtmlSelectOneListboxRenderer() {
        return (HtmlSelectOneListboxRenderer)this.createRenderer();
    }

    protected Renderer createRenderer() {
        HtmlSelectOneListboxRenderer renderer = new HtmlSelectOneListboxRenderer();
        renderer.setComponentIdLookupStrategy(this.getComponentIdLookupStrategy());
        return renderer;
    }
}

