/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.internal;

import java.util.HashMap;
import javax.faces.convert.BigDecimalConverter;
import javax.faces.convert.IntegerConverter;
import javax.faces.internal.ConverterBuilder;
import javax.faces.internal.ConverterResource;
import javax.faces.internal.HotDeployConverterBuilderImpl;
import javax.faces.internal.NormalConverterBuilderImpl;
import org.seasar.teeda.core.unit.TeedaTestCase;

public class ConverterResourceTest
extends TeedaTestCase {
    public void tearDown() throws Exception {
        ConverterResource.removeAll();
    }

    public void setUpGetConverter() throws Exception {
        this.register(IntegerConverter.class, "IntegerConverter");
        HotDeployConverterBuilderImpl builder = new HotDeployConverterBuilderImpl();
        builder.setContainer(this.getContainer());
        ConverterResource.setConverterBuilder((ConverterBuilder)builder);
    }

    public void tearDownGetConverter() throws Exception {
        ConverterResource.setConverterBuilder(null);
    }

    public void testGetConverter() throws Exception {
        ConverterResource.addConverter((String)"#{a.name}", (String)"IntegerConverter");
        ConverterResourceTest.assertNotNull((Object)ConverterResource.getConverter((String)"#{a.name}"));
        ConverterResourceTest.assertTrue((boolean)(ConverterResource.getConverter((String)"#{a.name}") instanceof IntegerConverter));
    }

    public void setUpGetConverter2() throws Exception {
        this.register(HogeBigDecimalConverter.class, "hogeBigDecimalConverter");
        HotDeployConverterBuilderImpl builder = new HotDeployConverterBuilderImpl();
        builder.setContainer(this.getContainer());
        ConverterResource.setConverterBuilder((ConverterBuilder)builder);
    }

    public void tearDownGetConverter2() throws Exception {
        ConverterResource.setConverterBuilder(null);
    }

    public void testGetConverter2() throws Exception {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("pattern", "YYYY/MM/dd");
        ConverterResource.addConverter((String)"#{a.name}", (String)"hogeBigDecimalConverter", properties);
        ConverterResourceTest.assertNotNull((Object)ConverterResource.getConverter((String)"#{a.name}"));
        ConverterResourceTest.assertTrue((boolean)(ConverterResource.getConverter((String)"#{a.name}") instanceof HogeBigDecimalConverter));
        HogeBigDecimalConverter dv = (HogeBigDecimalConverter)ConverterResource.getConverter((String)"#{a.name}");
        ConverterResourceTest.assertEquals((String)"YYYY/MM/dd", (String)dv.getPattern());
    }

    public void setUpGetConverter3() throws Exception {
        this.register(HogeBigDecimalConverter.class, "hogeBigDecimalConverter");
        NormalConverterBuilderImpl builder = new NormalConverterBuilderImpl();
        builder.setContainer(this.getContainer());
        ConverterResource.setConverterBuilder((ConverterBuilder)builder);
    }

    public void tearDownGetConverter3() throws Exception {
        ConverterResource.setConverterBuilder(null);
    }

    public void testGetConverter3() throws Exception {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("pattern", "yyyy/MM/dd");
        ConverterResource.addConverter((String)"#{a.name}", (String)"hogeBigDecimalConverter", properties);
        ConverterResourceTest.assertNotNull((Object)ConverterResource.getConverter((String)"#{a.name}"));
        ConverterResourceTest.assertTrue((boolean)(ConverterResource.getConverter((String)"#{a.name}") instanceof HogeBigDecimalConverter));
        HogeBigDecimalConverter dv = (HogeBigDecimalConverter)ConverterResource.getConverter((String)"#{a.name}");
        ConverterResourceTest.assertEquals((String)"yyyy/MM/dd", (String)dv.getPattern());
        ConverterResourceTest.assertTrue((dv.NUM == 1 ? 1 : 0) != 0);
        HogeBigDecimalConverter dv2 = (HogeBigDecimalConverter)ConverterResource.getConverter((String)"#{a.name}");
        ConverterResourceTest.assertEquals((String)"yyyy/MM/dd", (String)dv2.getPattern());
        ConverterResourceTest.assertTrue((dv.NUM == 2 ? 1 : 0) != 0);
    }

    public static class HogeBigDecimalConverter
    extends BigDecimalConverter {
        private String pattern;
        public int NUM = 0;

        public void setPattern(String pattern) {
            this.pattern = pattern;
        }

        public String getPattern() {
            ++this.NUM;
            return this.pattern;
        }
    }
}

