/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.event;

import javax.faces.component.UIComponent;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesListener;
import javax.faces.event.ValueChangeEvent;
import junit.framework.TestCase;
import org.seasar.teeda.core.mock.NullFacesListener;
import org.seasar.teeda.core.mock.NullUIComponent;
import org.seasar.teeda.core.mock.NullValueChangeListener;
import org.seasar.teeda.core.unit.ExceptionAssert;

public class ValueChangeEventTest
extends TestCase {
    public void testConstructor_ComponentIsNull() throws Exception {
        try {
            new ValueChangeEvent(null, (Object)"0", (Object)"1");
            ValueChangeEventTest.fail();
        }
        catch (IllegalArgumentException iae) {
            ExceptionAssert.assertMessageExist(iae);
        }
    }

    public void testGetOldValue() throws Exception {
        ValueChangeEvent event = new ValueChangeEvent((UIComponent)new NullUIComponent(), (Object)"0", (Object)"1");
        ValueChangeEventTest.assertEquals((Object)"0", (Object)event.getOldValue());
    }

    public void testGetNewValue() throws Exception {
        ValueChangeEvent event = new ValueChangeEvent((UIComponent)new NullUIComponent(), (Object)"0", (Object)"1");
        ValueChangeEventTest.assertEquals((Object)"1", (Object)event.getNewValue());
    }

    public void testIsAppropriateListener_True() throws Exception {
        ValueChangeEvent event = new ValueChangeEvent((UIComponent)new NullUIComponent(), (Object)"0", (Object)"1");
        ValueChangeEventTest.assertEquals((boolean)true, (boolean)event.isAppropriateListener((FacesListener)new NullValueChangeListener()));
    }

    public void testIsAppropriateListener_False() throws Exception {
        ValueChangeEvent event = new ValueChangeEvent((UIComponent)new NullUIComponent(), (Object)"0", (Object)"1");
        ValueChangeEventTest.assertEquals((boolean)false, (boolean)event.isAppropriateListener((FacesListener)new NullFacesListener()));
    }

    public void testProcessListener() throws Exception {
        final boolean[] calls = new boolean[]{false};
        final Object[] params = new Object[]{null};
        ValueChangeEvent event = new ValueChangeEvent((UIComponent)new NullUIComponent(), (Object)"0", (Object)"1");
        event.processListener((FacesListener)new NullValueChangeListener(){

            public void processValueChange(ValueChangeEvent event) throws AbortProcessingException {
                calls[0] = true;
                params[0] = event;
            }
        });
        ValueChangeEventTest.assertEquals((boolean)true, (boolean)calls[0]);
        ValueChangeEventTest.assertEquals((Object)event, (Object)params[0]);
    }
}

