/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import java.util.Iterator;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIOutputTest;
import javax.faces.context.FacesContext;
import javax.faces.convert.IntegerConverter;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import javax.faces.event.FacesEvent;
import javax.faces.event.ValueChangeEvent;
import javax.faces.event.ValueChangeListener;
import javax.faces.internal.ConverterBuilder;
import javax.faces.internal.ConverterResource;
import javax.faces.internal.NormalConverterBuilderImpl;
import javax.faces.validator.Validator;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.impl.S2ContainerImpl;
import org.seasar.teeda.core.mock.MockFacesContext;
import org.seasar.teeda.core.mock.MockMethodBinding;
import org.seasar.teeda.core.mock.MockUIComponentBase;
import org.seasar.teeda.core.mock.MockValueBinding;
import org.seasar.teeda.core.mock.NullValidator;
import org.seasar.teeda.core.mock.NullValueChangeListener;
import org.seasar.teeda.core.unit.ExceptionAssert;

public class UIInputTest
extends UIOutputTest {
    public void testValue() throws Exception {
        UIInput input = this.createUIInput();
        input.setValue((Object)"");
        MockValueBinding vb = new MockValueBinding();
        vb.setValue((FacesContext)this.getFacesContext(), (Object)"hoge");
        input.setValueBinding("value", (ValueBinding)vb);
        Object value = input.getValue();
        UIInputTest.assertNull((Object)value);
    }

    public final void testSetGetSubmittedValue() {
        UIInput input = this.createUIInput();
        input.setSubmittedValue((Object)"aaa");
        UIInputTest.assertEquals((Object)"aaa", (Object)input.getSubmittedValue());
    }

    public final void testSetGetSubmittedValue_ValueBindingNotWork() {
        UIInput input = this.createUIInput();
        MockValueBinding vb = new MockValueBinding();
        vb.setValue((FacesContext)this.getFacesContext(), (Object)"b");
        input.setValueBinding("submittedValue", (ValueBinding)vb);
        UIInputTest.assertEquals(null, (Object)input.getSubmittedValue());
    }

    public final void testSetGetLocalValueSet() {
        UIInput input = this.createUIInput();
        input.setLocalValueSet(true);
        UIInputTest.assertEquals((boolean)true, (boolean)input.isLocalValueSet());
    }

    public final void testSetValueToIsLocalValueSet() throws Exception {
        UIInput input = this.createUIInput();
        UIInputTest.assertEquals((boolean)false, (boolean)input.isLocalValueSet());
        input.setValue((Object)"aaaa");
        UIInputTest.assertEquals((boolean)true, (boolean)input.isLocalValueSet());
    }

    public final void testSetGetRequired() {
        UIInput input = this.createUIInput();
        input.setRequired(true);
        UIInputTest.assertEquals((boolean)true, (boolean)input.isRequired());
    }

    public final void testSetGetRequired_ValueBinding() {
        UIInput input = this.createUIInput();
        MockValueBinding vb = new MockValueBinding();
        vb.setValue((FacesContext)this.getFacesContext(), (Object)Boolean.TRUE);
        input.setValueBinding("required", (ValueBinding)vb);
        UIInputTest.assertEquals((boolean)true, (boolean)input.isRequired());
    }

    public final void testSetGetValid() {
        UIInput input = this.createUIInput();
        input.setValid(true);
        UIInputTest.assertEquals((boolean)true, (boolean)input.isValid());
    }

    public final void testSetGetValid_ValueBinding() {
        UIInput input = this.createUIInput();
        MockValueBinding vb = new MockValueBinding();
        vb.setValue((FacesContext)this.getFacesContext(), (Object)Boolean.TRUE);
        input.setValueBinding("valid", (ValueBinding)vb);
        UIInputTest.assertEquals((boolean)true, (boolean)input.isValid());
    }

    public final void testSetGetImmediate() {
        UIInput input = this.createUIInput();
        input.setImmediate(true);
        UIInputTest.assertEquals((boolean)true, (boolean)input.isImmediate());
    }

    public final void testSetGetImmediate_ValueBinding() {
        UIInput input = this.createUIInput();
        MockValueBinding vb = new MockValueBinding();
        vb.setValue((FacesContext)this.getFacesContext(), (Object)new Boolean(true));
        input.setValueBinding("immediate", (ValueBinding)vb);
        UIInputTest.assertEquals((boolean)true, (boolean)input.isImmediate());
    }

    public final void testSetGetValidator() {
        UIInput input = this.createUIInput();
        MockMethodBinding methodBinding = new MockMethodBinding();
        input.setValidator((MethodBinding)methodBinding);
        UIInputTest.assertEquals((Object)methodBinding, (Object)input.getValidator());
    }

    public final void testSetGetValueChangeListener() throws Exception {
        UIInput input = this.createUIInput();
        MockMethodBinding methodBinding = new MockMethodBinding();
        input.setValueChangeListener((MethodBinding)methodBinding);
        UIInputTest.assertEquals((Object)methodBinding, (Object)input.getValueChangeListener());
    }

    public final void testBroadcast_PassToListener() throws Exception {
        UIInput input = this.createUIInput();
        MockMethodBinding valueChangeMethod = new MockMethodBinding();
        input.setValueChangeListener((MethodBinding)valueChangeMethod);
        ValueChangeEvent event = new ValueChangeEvent((UIComponent)new MockUIComponentBase(), (Object)"1", (Object)"2");
        input.broadcast((FacesEvent)event);
        UIInputTest.assertEquals((boolean)true, (boolean)valueChangeMethod.isInvokeCalled());
        UIInputTest.assertEquals((int)1, (int)valueChangeMethod.getInvokeParams().length);
        UIInputTest.assertSame((Object)event, (Object)valueChangeMethod.getInvokeParams()[0]);
    }

    public final void testCompareValues() throws Exception {
        UIInput input = this.createUIInput();
        UIInputTest.assertEquals((boolean)false, (boolean)input.compareValues((Object)"1", (Object)"1"));
        UIInputTest.assertEquals((boolean)false, (boolean)input.compareValues((Object)"1", (Object)new String("1")));
        UIInputTest.assertEquals((boolean)false, (boolean)input.compareValues((Object)new Integer(1234), (Object)new Integer(1234)));
        UIInputTest.assertEquals((boolean)false, (boolean)input.compareValues((Object)"", (Object)""));
        UIInputTest.assertEquals((boolean)false, (boolean)input.compareValues(null, null));
        UIInputTest.assertEquals((boolean)true, (boolean)input.compareValues((Object)"", null));
        UIInputTest.assertEquals((boolean)true, (boolean)input.compareValues(null, (Object)""));
        UIInputTest.assertEquals((boolean)true, (boolean)input.compareValues((Object)"1", null));
        UIInputTest.assertEquals((boolean)true, (boolean)input.compareValues(null, (Object)"1"));
        UIInputTest.assertEquals((boolean)true, (boolean)input.compareValues((Object)"1", (Object)"2"));
        UIInputTest.assertEquals((boolean)true, (boolean)input.compareValues((Object)"2", (Object)"1"));
        UIInputTest.assertEquals((boolean)true, (boolean)input.compareValues((Object)new Integer(1234), (Object)new Integer(1233)));
    }

    public final void testAddValidator_NullArg() throws Exception {
        UIInput input = this.createUIInput();
        try {
            input.addValidator(null);
            UIInputTest.fail();
        }
        catch (NullPointerException npe) {
            ExceptionAssert.assertMessageExist(npe);
        }
    }

    public final void testAddGetRemoveValidators() throws Exception {
        UIInput input = this.createUIInput();
        UIInputTest.assertEquals((int)0, (int)input.getValidators().length);
        NullValidator v1 = new NullValidator();
        NullValidator v2 = new NullValidator();
        NullValidator v3 = new NullValidator();
        input.addValidator((Validator)v1);
        UIInputTest.assertEquals((int)1, (int)input.getValidators().length);
        input.addValidator((Validator)v2);
        UIInputTest.assertEquals((int)2, (int)input.getValidators().length);
        input.addValidator((Validator)v3);
        UIInputTest.assertEquals((int)3, (int)input.getValidators().length);
        input.removeValidator((Validator)v2);
        UIInputTest.assertEquals((int)2, (int)input.getValidators().length);
        input.removeValidator((Validator)v2);
        UIInputTest.assertEquals((int)2, (int)input.getValidators().length);
    }

    public final void testRemoveValidator_NullArg() throws Exception {
        UIInput input = this.createUIInput();
        input.removeValidator(null);
        UIInputTest.assertTrue((boolean)true);
    }

    public final void testAddValueChangeListener_NullArg() throws Exception {
        UIInput input = this.createUIInput();
        try {
            input.addValueChangeListener(null);
            UIInputTest.fail();
        }
        catch (NullPointerException npe) {
            ExceptionAssert.assertMessageExist(npe);
        }
    }

    public final void testAddGetRemoveValueChangeListeners() throws Exception {
        UIInput input = this.createUIInput();
        UIInputTest.assertEquals((int)0, (int)input.getValueChangeListeners().length);
        NullValueChangeListener v1 = new NullValueChangeListener();
        NullValueChangeListener v2 = new NullValueChangeListener();
        NullValueChangeListener v3 = new NullValueChangeListener();
        input.addValueChangeListener((ValueChangeListener)v1);
        UIInputTest.assertEquals((int)1, (int)input.getValueChangeListeners().length);
        input.addValueChangeListener((ValueChangeListener)v2);
        UIInputTest.assertEquals((int)2, (int)input.getValueChangeListeners().length);
        input.addValueChangeListener((ValueChangeListener)v3);
        UIInputTest.assertEquals((int)3, (int)input.getValueChangeListeners().length);
        input.removeValueChangeListener((ValueChangeListener)v2);
        UIInputTest.assertEquals((int)2, (int)input.getValueChangeListeners().length);
        input.removeValueChangeListener((ValueChangeListener)v2);
        UIInputTest.assertEquals((int)2, (int)input.getValueChangeListeners().length);
    }

    public final void testRemoveValueChangeListener_NullArg() throws Exception {
        UIInput input = this.createUIInput();
        try {
            input.removeValueChangeListener(null);
            UIInputTest.fail();
        }
        catch (NullPointerException npe) {
            ExceptionAssert.assertMessageExist(npe);
        }
    }

    public final void testSetValue_ConvertBlankToNull() throws Exception {
        UIInput input = this.createUIInput();
        input.setValue((Object)"");
        UIInputTest.assertEquals(null, (Object)input.getValue());
    }

    public void testGetConvertedValue() throws Exception {
        String clientId = "aaa";
        UIInput input = new UIInput(){

            public String getClientId(FacesContext context) {
                return "aaa";
            }
        };
        MockFacesContext context = this.getFacesContext();
        MockValueBinding vb = new MockValueBinding("aaa");
        vb.setExpressionString("bbb");
        input.setValueBinding("value", (ValueBinding)vb);
        S2ContainerImpl container = new S2ContainerImpl();
        container.register(IntegerConverter.class, "integerConverter");
        ConverterResource.setConverterBuilder((ConverterBuilder)new NormalConverterBuilderImpl((S2Container)container));
        ConverterResource.addConverter((String)"bbb", (String)"integerConverter");
        String submittedValue = "sss";
        UIInputTest.assertNotNull((Object)input.getConvertedValue((FacesContext)context, (Object)submittedValue));
        UIInputTest.assertTrue((context.getMessages() != null ? 1 : 0) != 0);
        Iterator itr = context.getMessages();
        int c = 0;
        while (itr.hasNext()) {
            FacesMessage fm = (FacesMessage)itr.next();
            UIInputTest.assertNotNull((Object)fm);
            ++c;
        }
        UIInputTest.assertTrue((c == 1 ? 1 : 0) != 0);
        container.destroy();
    }

    private UIInput createUIInput() {
        return (UIInput)this.createUIComponent();
    }

    protected UIComponent createUIComponent() {
        return new UIInput();
    }
}

