/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.render;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.render.Renderer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import junit.framework.TestCase;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.DifferenceListener;
import org.custommonkey.xmlunit.XMLUnit;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.core.context.html.HtmlResponseWriter;
import org.seasar.teeda.core.mock.MockApplication;
import org.seasar.teeda.core.mock.MockFacesContext;
import org.seasar.teeda.core.mock.MockFacesContextImpl;
import org.seasar.teeda.core.mock.MockVariableResolver;
import org.seasar.teeda.core.render.ComponentIdLookupStrategy;
import org.seasar.teeda.core.render.DefaultComponentIdLookupStrategy;
import org.seasar.teeda.core.unit.xmlunit.DifferenceListenerChain;
import org.seasar.teeda.core.unit.xmlunit.HtmlDomUtil;
import org.seasar.teeda.core.unit.xmlunit.IgnoreJsessionidDifferenceListener;
import org.seasar.teeda.core.unit.xmlunit.RegexpDifferenceListener;
import org.seasar.teeda.core.unit.xmlunit.TextTrimmingDifferenceListener;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class AbstractRendererTest
extends TestCase {
    protected MockFacesContext mockFacesContext_;
    protected ComponentIdLookupStrategy idLookupStrategy_;

    protected void setUp() throws Exception {
        super.setUp();
        this.mockFacesContext_ = new MockFacesContextImpl();
        this.idLookupStrategy_ = new DefaultComponentIdLookupStrategy();
    }

    protected void tearDown() throws Exception {
        this.mockFacesContext_.release();
        this.idLookupStrategy_ = null;
        super.tearDown();
    }

    protected MockFacesContext getFacesContext() {
        return this.mockFacesContext_;
    }

    protected MockApplication getApplication() {
        return (MockApplication)this.mockFacesContext_.getApplication();
    }

    protected MockVariableResolver getVariableResolver() {
        return (MockVariableResolver)this.getApplication().getVariableResolver();
    }

    protected ComponentIdLookupStrategy getComponentIdLookupStrategy() {
        return this.idLookupStrategy_;
    }

    protected String getResponseText() throws IOException {
        HtmlResponseWriter htmlResponseWriter = (HtmlResponseWriter)this.mockFacesContext_.getResponseWriter();
        return htmlResponseWriter.getWriter().toString();
    }

    protected void encodeByRenderer(Renderer renderer, UIComponent component) throws IOException {
        this.encodeByRenderer(renderer, (FacesContext)this.getFacesContext(), component);
    }

    protected void encodeByRenderer(Renderer renderer, FacesContext context, UIComponent component) throws IOException {
        renderer.encodeBegin(context, component);
        if (renderer.getRendersChildren()) {
            renderer.encodeChildren(context, component);
        }
        renderer.encodeEnd(context, component);
    }

    protected String extract(String s) {
        int end;
        String BEGIN = "<!-- BEGIN -->";
        String END = "<!-- END -->";
        int begin = s.indexOf("<!-- BEGIN -->");
        if (-1 < begin && -1 < (end = s.indexOf("<!-- END -->", begin + "<!-- BEGIN -->".length()))) {
            return s.substring(begin + "<!-- BEGIN -->".length(), end);
        }
        return s;
    }

    protected Diff diff(String expected, String actual) throws SAXException, IOException, ParserConfigurationException {
        Document cDoc = XMLUnit.buildDocument((DocumentBuilder)XMLUnit.getControlParser(), (Reader)new StringReader(this.revertEntity(expected)));
        Document tDoc = XMLUnit.buildDocument((DocumentBuilder)XMLUnit.getTestParser(), (Reader)new StringReader(this.revertEntity(actual)));
        HtmlDomUtil.removeBlankTextNode((NodeList)cDoc.getChildNodes());
        HtmlDomUtil.removeBlankTextNode((NodeList)tDoc.getChildNodes());
        Diff diff = new Diff(cDoc, tDoc);
        DifferenceListenerChain chain = new DifferenceListenerChain();
        chain.addDifferenceListener((DifferenceListener)new TextTrimmingDifferenceListener());
        chain.addDifferenceListener((DifferenceListener)new IgnoreJsessionidDifferenceListener());
        chain.addDifferenceListener((DifferenceListener)new RegexpDifferenceListener());
        diff.overrideDifferenceListener((DifferenceListener)chain);
        return diff;
    }

    private String revertEntity(String s) {
        s = StringUtil.replace((String)s, (String)"&nbsp;", (String)" ");
        return s;
    }

    protected String afterText(String s1, String s2) {
        int pos = s1.indexOf(s2);
        if (pos == -1) {
            return s1;
        }
        return s1.substring(pos + s2.length()).trim();
    }
}

