/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.internal;

import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.internal.ValidatorChain;
import javax.faces.validator.DoubleRangeValidator;
import javax.faces.validator.LengthValidator;
import javax.faces.validator.Validator;
import org.seasar.teeda.core.mock.MockFacesContext;
import org.seasar.teeda.core.mock.MockUIComponent;
import org.seasar.teeda.core.unit.TeedaTestCase;
import org.seasar.teeda.core.unit.TestUtil;

public class ValidatorChainTest
extends TeedaTestCase {
    public void testValidate() throws Exception {
        final boolean[] calls = new boolean[]{false, false};
        Validator v1 = new Validator(){

            public void validate(FacesContext context, UIComponent component, Object value) throws FacesException {
                calls[0] = true;
            }
        };
        Validator v2 = new Validator(){

            public void validate(FacesContext context, UIComponent component, Object value) throws FacesException {
                calls[1] = true;
            }
        };
        ValidatorChain chain = new ValidatorChain();
        chain.add(v1);
        chain.add(v2);
        MockUIComponent component = new MockUIComponent();
        component.setId("aaa");
        chain.validate((FacesContext)this.getFacesContext(), (UIComponent)component, (Object)new Integer(2));
        ValidatorChainTest.assertTrue((boolean)calls[0]);
        ValidatorChainTest.assertTrue((boolean)calls[1]);
    }

    public void testSaveAndRestoreState() throws Exception {
        ValidatorChain chain1 = new ValidatorChain();
        LengthValidator lengthValidator = new LengthValidator();
        lengthValidator.setMaximum(33);
        chain1.add((Validator)lengthValidator);
        DoubleRangeValidator doubleRangeValidator = new DoubleRangeValidator();
        doubleRangeValidator.setMinimum(10.0);
        doubleRangeValidator.setMaximum(21.0);
        chain1.add((Validator)doubleRangeValidator);
        MockFacesContext context = this.getFacesContext();
        Object saved = chain1.saveState((FacesContext)context);
        Object decoded = TestUtil.serializeAndDeserialize(saved);
        ValidatorChain chain2 = new ValidatorChain();
        chain2.restoreState((FacesContext)context, decoded);
        ValidatorChainTest.assertEquals((int)2, (int)chain2.getValidatorSize());
        LengthValidator lengthValidator2 = (LengthValidator)chain2.getValidator(0);
        ValidatorChainTest.assertEquals((int)33, (int)lengthValidator2.getMaximum());
        DoubleRangeValidator doubleRangeValidator2 = (DoubleRangeValidator)chain2.getValidator(1);
        ValidatorChainTest.assertEquals((double)10.0, (double)doubleRangeValidator2.getMinimum(), (double)0.0);
        ValidatorChainTest.assertEquals((double)21.0, (double)doubleRangeValidator2.getMaximum(), (double)0.0);
    }
}

