/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.util;

import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.faces.context.FacesContext;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.core.util.ResourceBundleMap;

public class MessageBundle
implements Map {
    private final String baseName;

    public MessageBundle(String baseName) {
        if (baseName == null) {
            throw new NullPointerException("baseName");
        }
        if (StringUtil.isBlank((String)baseName)) {
            throw new IllegalArgumentException("baseName [" + baseName + "]");
        }
        this.baseName = baseName;
    }

    ResourceBundle getResourceBundle() {
        return ResourceBundle.getBundle(this.baseName, this.getLocale(), this.getClassLoader());
    }

    private Locale getLocale() {
        FacesContext context = FacesContext.getCurrentInstance();
        Locale locale = context.getViewRoot().getLocale();
        if (locale != null) {
            return locale;
        }
        return context.getApplication().getDefaultLocale();
    }

    private ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    Map getResourceBundleMap() {
        return new ResourceBundleMap(this.getResourceBundle());
    }

    public void clear() {
        this.getResourceBundleMap().clear();
    }

    public boolean containsKey(Object key) {
        return this.getResourceBundleMap().containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.getResourceBundleMap().containsValue(value);
    }

    public Set entrySet() {
        return this.getResourceBundleMap().entrySet();
    }

    public Object get(Object key) {
        return this.getResourceBundleMap().get(key);
    }

    public boolean isEmpty() {
        return this.getResourceBundleMap().isEmpty();
    }

    public Set keySet() {
        return this.getResourceBundleMap().keySet();
    }

    public Object put(Object key, Object value) {
        return this.getResourceBundleMap().put(key, value);
    }

    public void putAll(Map t) {
        this.getResourceBundleMap().putAll(t);
    }

    public Object remove(Object key) {
        return this.getResourceBundleMap().remove(key);
    }

    public int size() {
        return this.getResourceBundleMap().size();
    }

    public Collection values() {
        return this.getResourceBundleMap().values();
    }
}

