/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.application;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.application.NavigationHandler;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.seasar.framework.util.AssertionUtil;
import org.seasar.teeda.core.application.navigation.NavigationCaseContext;
import org.seasar.teeda.core.application.navigation.NavigationContext;
import org.seasar.teeda.core.application.navigation.NavigationResource;
import org.seasar.teeda.core.util.IteratorUtil;
import org.seasar.teeda.core.util.NavigationHandlerUtil;
import org.seasar.teeda.core.util.PortletUtil;

public class NavigationHandlerImpl
extends NavigationHandler {
    public void handleNavigation(FacesContext context, String fromAction, String outcome) {
        AssertionUtil.assertNotNull((String)"context is null.", (Object)context);
        if (outcome == null) {
            return;
        }
        ExternalContext externalContext = context.getExternalContext();
        String viewId = context.getViewRoot().getViewId();
        NavigationCaseContext navigationCaseContext = this.getNavigationCaseContext(fromAction, outcome, viewId);
        if (navigationCaseContext != null) {
            ViewHandler viewHandler = context.getApplication().getViewHandler();
            String newViewId = navigationCaseContext.getToViewId();
            if (this.isRedirect(context, navigationCaseContext)) {
                String redirectPath = this.getRedirectActionPath(context, viewHandler, newViewId);
                this.redirect(context, externalContext, redirectPath, newViewId);
            } else {
                this.render(context, viewHandler, newViewId);
            }
        }
    }

    protected String getRedirectActionPath(FacesContext context, ViewHandler viewHandler, String newViewId) {
        return viewHandler.getActionURL(context, newViewId);
    }

    protected void redirect(FacesContext context, ExternalContext externalContext, String redirectPath, String newViewId) {
        NavigationHandlerUtil.redirect(context, redirectPath);
    }

    protected void render(FacesContext context, ViewHandler viewHandler, String newViewId) {
        UIViewRoot viewRoot = viewHandler.createView(context, newViewId);
        viewRoot.setViewId(newViewId);
        context.setViewRoot(viewRoot);
        context.renderResponse();
    }

    protected boolean isRedirect(FacesContext context, NavigationCaseContext caseContext) {
        if (PortletUtil.isPortlet(context)) {
            return false;
        }
        return caseContext.isRedirect();
    }

    protected NavigationCaseContext getNavigationCaseContext(String fromAction, String outcome, String viewId) {
        List navigationList = this.getExactMatchNavigationCases(viewId);
        NavigationCaseContext navigationCaseContext = this.getNavigationCaseContextInternal(navigationList, fromAction, outcome);
        if (navigationCaseContext == null) {
            navigationList = this.getWildCardMatchNavigationCases(viewId);
            navigationCaseContext = this.getNavigationCaseContextInternal(navigationList, fromAction, outcome);
        }
        if (navigationCaseContext == null) {
            navigationList = this.getDefaultNavigationCases(viewId);
            navigationCaseContext = this.getNavigationCaseContextInternal(navigationList, fromAction, outcome);
        }
        return navigationCaseContext;
    }

    private NavigationCaseContext getNavigationCaseContextInternal(List navigationList, String fromAction, String outcome) {
        Iterator itr = IteratorUtil.getIterator(navigationList);
        while (itr.hasNext()) {
            NavigationContext navContext = (NavigationContext)itr.next();
            NavigationCaseContext caseContext = navContext.getNavigationCase(fromAction, outcome);
            if (caseContext == null) continue;
            return caseContext;
        }
        return null;
    }

    protected List getExactMatchNavigationCases(String viewId) {
        Map map = NavigationResource.getNavigationContexts();
        if (map != null) {
            return (List)map.get(viewId);
        }
        return null;
    }

    protected List getWildCardMatchNavigationCases(String viewId) {
        Map map = NavigationResource.getWildCardMatchNavigationContexts();
        if (map != null) {
            Iterator itr = map.keySet().iterator();
            while (itr.hasNext()) {
                String key = (String)itr.next();
                if (!viewId.startsWith(key = key.substring(0, key.lastIndexOf("*")))) continue;
                return (List)map.get(key + "*");
            }
        }
        return null;
    }

    protected List getDefaultNavigationCases(String viewId) {
        Map map = NavigationResource.getDefaultMatchNavigationContexts();
        if (map != null) {
            return (List)map.get("*");
        }
        return null;
    }
}

