/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.context;

import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletContext;
import junit.framework.TestCase;
import org.seasar.framework.mock.servlet.MockServletContext;
import org.seasar.framework.mock.servlet.MockServletContextImpl;
import org.seasar.teeda.core.context.AbstractExternalContextMap;

public class AbstractExternalContextMapTest
extends TestCase {
    private MockServletContext context_;

    protected void setUp() throws Exception {
        this.context_ = new MockServletContextImpl(null);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public AbstractExternalContextMapTest(String arg0) {
        super(arg0);
    }

    public void testGet() {
        ExternalContextMap map = new ExternalContextMap((ServletContext)this.context_);
        map.put("a", "A");
        AbstractExternalContextMapTest.assertEquals((Object)"A", (Object)map.get("a"));
    }

    public void testPutAll() {
        ExternalContextMap map = new ExternalContextMap((ServletContext)this.context_);
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("a", "A");
        m.put("b", "B");
        map.putAll(m);
        AbstractExternalContextMapTest.assertEquals((Object)"A", (Object)map.get("a"));
        AbstractExternalContextMapTest.assertEquals((Object)"B", (Object)map.get("b"));
    }

    public void testIsEmpty() {
        ExternalContextMap map = new ExternalContextMap((ServletContext)this.context_);
        AbstractExternalContextMapTest.assertTrue((boolean)map.isEmpty());
        map.put("a", "A");
        AbstractExternalContextMapTest.assertFalse((boolean)map.isEmpty());
    }

    public void testClear() {
        ExternalContextMap map = new ExternalContextMap((ServletContext)this.context_);
        map.put("c", "C");
        map.put("d", "D");
        AbstractExternalContextMapTest.assertNotNull((Object)map.get("c"));
        map.clear();
        AbstractExternalContextMapTest.assertNull((Object)map.get("c"));
    }

    public void testContainsKey() {
        ExternalContextMap map = new ExternalContextMap((ServletContext)this.context_);
        map.put("e", "E");
        AbstractExternalContextMapTest.assertTrue((boolean)map.containsKey("e"));
        AbstractExternalContextMapTest.assertFalse((boolean)map.containsKey("not_a_key"));
    }

    public void testContainsValue() {
        ExternalContextMap map = new ExternalContextMap((ServletContext)this.context_);
        map.put("f", "F");
        map.put("g", "F");
        map.put("h", "H");
        AbstractExternalContextMapTest.assertTrue((boolean)map.containsValue("F"));
        AbstractExternalContextMapTest.assertFalse((boolean)map.containsValue("not_a_value"));
    }

    public void testEntrySet() {
        ExternalContextMap map = new ExternalContextMap((ServletContext)this.context_);
        map.put("a", "A");
        map.put("b", "B");
        Iterator itr = map.entrySet().iterator();
        while (itr.hasNext()) {
            Object o = itr.next();
            AbstractExternalContextMapTest.assertNotNull(o);
            AbstractExternalContextMapTest.assertTrue((boolean)(o instanceof Map.Entry));
        }
    }

    public void testKeySet() {
        this.context_.setAttribute("a", (Object)"A");
        this.context_.setAttribute("b", (Object)"B");
        ExternalContextMap map = new ExternalContextMap((ServletContext)this.context_);
        Iterator itr = map.keySet().iterator();
        while (itr.hasNext()) {
            Object o = itr.next();
            AbstractExternalContextMapTest.assertNotNull(o);
            AbstractExternalContextMapTest.assertTrue((boolean)(o instanceof String));
        }
    }

    public void testRemove() {
        this.context_.setAttribute("i", (Object)"I");
        ExternalContextMap map = new ExternalContextMap((ServletContext)this.context_);
        String s = (String)map.get("i");
        AbstractExternalContextMapTest.assertNotNull((Object)s);
        map.remove("i");
        AbstractExternalContextMapTest.assertNull((Object)map.get("i"));
    }

    public void testValues() {
        this.context_.setAttribute("j", (Object)"1");
        this.context_.setAttribute("k", (Object)"2");
        this.context_.setAttribute("l", (Object)"3");
        ExternalContextMap map = new ExternalContextMap((ServletContext)this.context_);
        Collection c = map.values();
        AbstractExternalContextMapTest.assertEquals((int)3, (int)c.size());
        AbstractExternalContextMapTest.assertTrue((boolean)c.contains("1"));
        AbstractExternalContextMapTest.assertTrue((boolean)c.contains("2"));
        AbstractExternalContextMapTest.assertTrue((boolean)c.contains("3"));
    }

    private static class ExternalContextMap
    extends AbstractExternalContextMap {
        private ServletContext context_;

        public ExternalContextMap(ServletContext context) {
            this.context_ = context;
        }

        protected Object getAttribute(String key) {
            return this.context_.getAttribute(key);
        }

        protected void setAttribute(String key, Object value) {
            this.context_.setAttribute(key, value);
        }

        protected Enumeration getAttributeNames() {
            return this.context_.getAttributeNames();
        }

        protected void removeAttribute(String key) {
            this.context_.removeAttribute(key);
        }
    }
}

