/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.convert;

import java.util.ArrayList;
import java.util.Locale;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.AbstractConverterTestCase;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.convert.IntegerConverter;
import org.seasar.teeda.core.mock.MockUIComponent;

public class IntegerConverterTest
extends AbstractConverterTestCase {
    public void testGetAsObject_convertSuccess() throws Exception {
        Converter converter = this.createConverter();
        Object o = converter.getAsObject((FacesContext)this.getFacesContext(), (UIComponent)new MockUIComponent(), "123");
        IntegerConverterTest.assertNotNull((Object)o);
        Integer i = (Integer)o;
        IntegerConverterTest.assertEquals((int)123, (int)i);
    }

    public void testGetAsObject_convertFail() throws Exception {
        Converter converter = this.createConverter();
        try {
            converter.getAsObject((FacesContext)this.getFacesContext(), (UIComponent)new MockUIComponent(), "aaa");
            IntegerConverterTest.fail();
        }
        catch (ConverterException expected) {
            IntegerConverterTest.success();
        }
    }

    public void testGetAsString_convertSuccess() throws Exception {
        Converter converter = this.createConverter();
        String value = converter.getAsString((FacesContext)this.getFacesContext(), (UIComponent)new MockUIComponent(), (Object)new Integer(123));
        IntegerConverterTest.assertEquals((String)"123", (String)value);
    }

    public void testGetAsString_convertFail() throws Exception {
        Converter converter = this.createConverter();
        try {
            converter.getAsString((FacesContext)this.getFacesContext(), (UIComponent)new MockUIComponent(), new ArrayList());
            IntegerConverterTest.fail();
        }
        catch (ConverterException expected) {
            IntegerConverterTest.success();
        }
    }

    public void testGetAsObject_convertWithDelimeter() throws Exception {
        Converter converter = this.createConverter();
        this.getFacesContext().getViewRoot().setLocale(Locale.JAPAN);
        Object o = converter.getAsObject((FacesContext)this.getFacesContext(), (UIComponent)new MockUIComponent(), "1,000,000");
        IntegerConverterTest.assertNotNull((Object)o);
        Integer i = (Integer)o;
        IntegerConverterTest.assertEquals((int)1000000, (int)i);
    }

    public void testConstants() throws Exception {
        IntegerConverterTest.assertEquals((String)"javax.faces.Integer", (String)"javax.faces.Integer");
    }

    protected Converter createConverter() {
        return this.createIntegerConverter();
    }

    protected IntegerConverter createIntegerConverter() {
        return new IntegerConverter();
    }
}

