/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.portlet.util;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.ReadOnlyException;
import javax.portlet.ValidatorException;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;

public class PortletPreferencesUtil {
    public static PortletPreferences getPortletPreferences() {
        S2Container container = SingletonS2ContainerFactory.getContainer();
        if (container == null) {
            throw new IllegalStateException("S2Container is null.");
        }
        if (container.getExternalContext().getRequest() instanceof PortletRequest) {
            return ((PortletRequest)container.getExternalContext().getRequest()).getPreferences();
        }
        return null;
    }

    public static boolean isReadOnly(String key) {
        PortletPreferences prefs = PortletPreferencesUtil.getPortletPreferences();
        if (prefs == null) {
            throw new IllegalStateException("Cannot retrieve PortletPreferences.");
        }
        return prefs.isReadOnly(key);
    }

    public static String getValue(String key, String def) {
        PortletPreferences prefs = PortletPreferencesUtil.getPortletPreferences();
        if (prefs == null) {
            return def;
        }
        return prefs.getValue(key, def);
    }

    public static String[] getValues(String key, String[] def) {
        PortletPreferences prefs = PortletPreferencesUtil.getPortletPreferences();
        if (prefs == null) {
            return def;
        }
        return prefs.getValues(key, def);
    }

    public static void setValue(String key, String value) throws IOException {
        PortletPreferences prefs = PortletPreferencesUtil.getPortletPreferences();
        if (prefs == null) {
            throw new IllegalStateException("Cannot retrieve PortletPreferences.");
        }
        try {
            prefs.setValue(key, value);
        }
        catch (ReadOnlyException e) {
            throw new IOException(e.toString());
        }
    }

    public static void setValues(String key, String[] values) throws IOException {
        PortletPreferences prefs = PortletPreferencesUtil.getPortletPreferences();
        if (prefs == null) {
            throw new IllegalStateException("Cannot retrieve PortletPreferences.");
        }
        try {
            prefs.setValues(key, values);
        }
        catch (ReadOnlyException e) {
            throw new IOException(e.toString());
        }
    }

    public static Enumeration getNames() {
        PortletPreferences prefs = PortletPreferencesUtil.getPortletPreferences();
        if (prefs == null) {
            throw new IllegalStateException("Cannot retrieve PortletPreferences.");
        }
        return prefs.getNames();
    }

    public static Map getMap() {
        PortletPreferences prefs = PortletPreferencesUtil.getPortletPreferences();
        if (prefs == null) {
            throw new IllegalStateException("Cannot retrieve PortletPreferences.");
        }
        return prefs.getMap();
    }

    public static void reset(String key) throws IOException {
        PortletPreferences prefs = PortletPreferencesUtil.getPortletPreferences();
        if (prefs == null) {
            throw new IllegalStateException("Cannot retrieve PortletPreferences.");
        }
        try {
            prefs.reset(key);
        }
        catch (ReadOnlyException e) {
            throw new IOException(e.toString());
        }
    }

    public static void store() throws IOException {
        PortletPreferences prefs = PortletPreferencesUtil.getPortletPreferences();
        if (prefs == null) {
            throw new IllegalStateException("Cannot retrieve PortletPreferences.");
        }
        try {
            prefs.store();
        }
        catch (ValidatorException e) {
            throw new IOException(e.toString());
        }
    }
}

