/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.html.impl;

import org.seasar.teeda.extension.html.ActionDesc;
import org.seasar.teeda.extension.html.DocumentNode;
import org.seasar.teeda.extension.html.ElementNode;
import org.seasar.teeda.extension.html.ElementProcessor;
import org.seasar.teeda.extension.html.ElementProcessorFactory;
import org.seasar.teeda.extension.html.HtmlDesc;
import org.seasar.teeda.extension.html.HtmlNode;
import org.seasar.teeda.extension.html.PageDesc;
import org.seasar.teeda.extension.html.TagProcessor;
import org.seasar.teeda.extension.html.TagProcessorAssembler;
import org.seasar.teeda.extension.html.TextNode;
import org.seasar.teeda.extension.html.processor.ViewProcessor;

public class TagProcessorAssemblerImpl
implements TagProcessorAssembler {
    private ElementProcessorFactory[] factories = new ElementProcessorFactory[0];

    public ElementProcessorFactory[] getFactories() {
        return this.factories;
    }

    public void setFactories(ElementProcessorFactory[] factories) {
        this.factories = factories;
    }

    public TagProcessor assemble(HtmlDesc htmlDesc, PageDesc pageDesc, ActionDesc actionDesc) {
        HtmlNode rootNode = htmlDesc.getHtmlNode();
        ViewProcessor rootProcessor = new ViewProcessor();
        this.assembleTagProcessor((ElementProcessor)rootProcessor, rootNode, pageDesc, actionDesc);
        rootProcessor.endElement();
        return rootProcessor;
    }

    protected void assembleTagProcessor(ElementProcessor parentProcessor, HtmlNode node, PageDesc pageDesc, ActionDesc actionDesc) {
        if (node instanceof TextNode) {
            this.assembleTagProcessor(parentProcessor, (TextNode)node);
        } else if (node instanceof DocumentNode) {
            this.assembleTagProcessor(parentProcessor, (DocumentNode)node, pageDesc, actionDesc);
        } else {
            this.assembleTagProcessor(parentProcessor, (ElementNode)node, pageDesc, actionDesc);
        }
    }

    protected void assembleTagProcessor(ElementProcessor parentProcessor, TextNode textNode) {
        parentProcessor.addText(textNode.getValue());
    }

    protected void assembleTagProcessor(ElementProcessor parentProcessor, DocumentNode node, PageDesc pageDesc, ActionDesc actionDesc) {
        String docType = node.getDocType();
        if (docType != null) {
            parentProcessor.addText(docType);
        }
        for (int i = 0; i < node.getChildSize(); ++i) {
            HtmlNode child = node.getChild(i);
            this.assembleTagProcessor(parentProcessor, child, pageDesc, actionDesc);
        }
    }

    protected void assembleTagProcessor(ElementProcessor parentProcessor, ElementNode elementNode, PageDesc pageDesc, ActionDesc actionDesc) {
        for (int i = 0; i < this.factories.length; ++i) {
            ElementProcessorFactory factory = this.factories[i];
            if (!factory.isMatch(elementNode, pageDesc, actionDesc)) continue;
            ElementProcessor elementProcessor = factory.createProcessor(elementNode, pageDesc, actionDesc);
            parentProcessor.addElement(elementProcessor);
            if (!factory.isLeaf()) {
                this.assembleElementNodeChildren(elementProcessor, elementNode, pageDesc, actionDesc);
            }
            elementProcessor.endElement();
            return;
        }
        this.assembleElementNodeAsText(parentProcessor, elementNode, pageDesc, actionDesc);
    }

    protected void assembleElementNodeAsText(ElementProcessor parentProcessor, ElementNode elementNode, PageDesc pageDesc, ActionDesc actionDesc) {
        if (elementNode.getChildSize() == 0) {
            parentProcessor.addText(elementNode.getCompleteTagString());
        } else {
            parentProcessor.addText(elementNode.getStartTagString());
            this.assembleElementNodeChildren(parentProcessor, elementNode, pageDesc, actionDesc);
            parentProcessor.addText(elementNode.getEndTagString());
        }
    }

    protected void assembleElementNodeChildren(ElementProcessor parentProcessor, ElementNode elementNode, PageDesc pageDesc, ActionDesc actionDesc) {
        for (int i = 0; i < elementNode.getChildSize(); ++i) {
            this.assembleTagProcessor(parentProcessor, elementNode.getChild(i), pageDesc, actionDesc);
        }
    }
}

