/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.convert;

import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.CharacterConverter;
import javax.faces.convert.ConverterException;
import org.seasar.framework.util.AssertionUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.core.util.HTMLEncodeUtil;
import org.seasar.teeda.extension.convert.ConvertTargetSelectable;
import org.seasar.teeda.extension.convert.ConverterHelper;
import org.seasar.teeda.extension.util.TargetCommandUtil;

public class TextareaSeparatorCharacterConverter
extends CharacterConverter
implements ConvertTargetSelectable,
StateHolder {
    protected String target;
    protected String[] targets;
    protected String objectMessageId;
    protected String stringMessageId;
    protected boolean transientValue = false;
    private static final String SEP1 = "\r\n";
    private static final String SEP2 = "\r";
    private static final String SEP3 = "\n";

    public Object getAsObject(FacesContext context, UIComponent component, String value) throws ConverterException {
        AssertionUtil.assertNotNull((String)"FacesContext", (Object)context);
        AssertionUtil.assertNotNull((String)"UIComponent", (Object)component);
        if (StringUtil.isEmpty((String)value)) {
            return null;
        }
        if (!ConverterHelper.isTargetCommand(context, component, this.targets, this)) {
            return value;
        }
        return value;
    }

    public String getAsString(FacesContext context, UIComponent component, Object value) throws ConverterException {
        if (!this.isTargetCommandConvert(context, this.targets)) {
            return null;
        }
        String s = super.getAsString(context, component, value);
        s = HTMLEncodeUtil.encodeAll((String)s);
        return s.replaceAll(SEP1, "<br/>").replaceAll(SEP2, "<br/>").replaceAll(SEP3, "<br/>");
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
        if (StringUtil.isEmpty((String)target)) {
            return;
        }
        this.targets = StringUtil.split((String)target, (String)", ");
    }

    public boolean isTargetCommandConvert(FacesContext context, String[] targets) {
        return TargetCommandUtil.isTargetCommand(context, targets);
    }

    public boolean isTransient() {
        return this.transientValue;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this.target = (String)values[0];
        this.setTarget(this.target);
        this.objectMessageId = (String)values[1];
        this.stringMessageId = (String)values[2];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{this.target, this.objectMessageId, this.stringMessageId};
        return values;
    }

    public void setTransient(boolean transientValue) {
        this.transientValue = transientValue;
    }

    public String getObjectMessageId() {
        return !StringUtil.isEmpty((String)this.objectMessageId) ? this.objectMessageId : super.getObjectMessageId();
    }

    public void setObjectMessageId(String objectMessageId) {
        this.objectMessageId = objectMessageId;
    }

    public String getStringMessageId() {
        return !StringUtil.isEmpty((String)this.stringMessageId) ? this.stringMessageId : super.getStringMessageId();
    }

    public void setStringMessageId(String stringMessageId) {
        this.stringMessageId = stringMessageId;
    }
}

