/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.el;

import java.util.HashMap;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.VariableResolver;
import org.seasar.framework.container.S2Container;
import org.seasar.teeda.core.el.FacesResolver;
import org.seasar.teeda.core.el.impl.ApplicationScopeResolver;
import org.seasar.teeda.core.el.impl.CookieResolver;
import org.seasar.teeda.core.el.impl.FacesContextResolver;
import org.seasar.teeda.core.el.impl.HeaderResolver;
import org.seasar.teeda.core.el.impl.HeaderValuesResolver;
import org.seasar.teeda.core.el.impl.InitParamResolver;
import org.seasar.teeda.core.el.impl.ParamResolver;
import org.seasar.teeda.core.el.impl.ParamValuesResolver;
import org.seasar.teeda.core.el.impl.RequestScopeResolver;
import org.seasar.teeda.core.el.impl.SessionScopeResolver;
import org.seasar.teeda.core.el.impl.ViewResolver;
import org.seasar.teeda.core.util.BindingUtil;

public class TeedaVariableResolver
extends VariableResolver {
    private static Map facesResolvers = new HashMap();
    private S2Container container;

    public Object resolveVariable(FacesContext context, String name) throws EvaluationException {
        FacesResolver resolver = (FacesResolver)facesResolvers.get(name);
        if (resolver != null) {
            return resolver.resolveVariable(context);
        }
        return BindingUtil.getValue(this.container, name);
    }

    public void setContainer(S2Container container) {
        this.container = container;
        if (container != null) {
            this.container = container.getRoot();
        }
    }

    static {
        facesResolvers.put("applicationScope", new ApplicationScopeResolver());
        facesResolvers.put("cookie", new CookieResolver());
        facesResolvers.put("facesContext", new FacesContextResolver());
        facesResolvers.put("header", new HeaderResolver());
        facesResolvers.put("headerValues", new HeaderValuesResolver());
        facesResolvers.put("initParam", new InitParamResolver());
        facesResolvers.put("param", new ParamResolver());
        facesResolvers.put("paramValues", new ParamValuesResolver());
        facesResolvers.put("requestScope", new RequestScopeResolver());
        facesResolvers.put("sessionScope", new SessionScopeResolver());
        facesResolvers.put("view", new ViewResolver());
    }
}

