/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.beans.converter;

import java.text.DecimalFormat;
import java.text.ParseException;
import org.seasar.framework.beans.Converter;
import org.seasar.framework.exception.EmptyRuntimeException;
import org.seasar.framework.exception.ParseRuntimeException;
import org.seasar.framework.util.StringUtil;

public class NumberConverter
implements Converter {
    protected String pattern;

    public NumberConverter(String pattern) {
        if (StringUtil.isEmpty(pattern)) {
            throw new EmptyRuntimeException("pattern");
        }
        this.pattern = pattern;
    }

    public Object getAsObject(String value) {
        if (StringUtil.isEmpty(value)) {
            return null;
        }
        try {
            return new DecimalFormat(this.pattern).parse(value);
        }
        catch (ParseException e) {
            throw new ParseRuntimeException(e);
        }
    }

    public String getAsString(Object value) {
        return new DecimalFormat(this.pattern).format(value);
    }

    public boolean isTarget(Class clazz) {
        return Number.class.isAssignableFrom(clazz);
    }
}

