/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.el.impl.commons;

import java.util.List;
import javax.faces.application.Application;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.el.FunctionMapper;
import javax.servlet.jsp.el.VariableResolver;
import org.apache.commons.el.ArraySuffix;
import org.apache.commons.el.ComplexValue;
import org.apache.commons.el.Expression;
import org.apache.commons.el.Logger;
import org.apache.commons.el.PropertySuffix;
import org.apache.commons.el.ValueSuffix;
import org.seasar.teeda.core.el.ExpressionProcessor;
import org.seasar.teeda.core.el.Replacer;
import org.seasar.teeda.core.util.ApplicationUtil;
import org.seasar.teeda.core.util.PropertyResolverUtil;

public class ComplexValueReplacer
implements Replacer {
    private ExpressionProcessor processor_;

    public ComplexValueReplacer(ExpressionProcessor processor) {
        this.processor_ = processor;
    }

    public void replace(Object expression) {
        ComplexValue complexValue = (ComplexValue)expression;
        Application application = ApplicationUtil.getApplicationFromContext();
        List suffixes = complexValue.getSuffixes();
        for (int i = 0; i < suffixes.size(); ++i) {
            ValueSuffix valueSuffix = (ValueSuffix)suffixes.get(i);
            if (ComplexValueReplacer.isSuitablePropertySuffix(valueSuffix)) {
                PropertySuffix propertySuffix = (PropertySuffix)valueSuffix;
                suffixes.set(i, new JsfPropertySuffix(propertySuffix, application, this.processor_));
                continue;
            }
            if (ComplexValueReplacer.isSuitableArraySuffix(valueSuffix)) {
                ArraySuffix arraySuffix = (ArraySuffix)valueSuffix;
                suffixes.set(i, new JsfArraySuffix(arraySuffix, application, this.processor_));
                continue;
            }
            throw new IllegalStateException();
        }
    }

    private static boolean isSuitablePropertySuffix(ValueSuffix valueSuffix) {
        return valueSuffix instanceof PropertySuffix && !(valueSuffix instanceof JsfPropertySuffix);
    }

    private static boolean isSuitableArraySuffix(ValueSuffix valueSuffix) {
        return valueSuffix instanceof ArraySuffix && !(valueSuffix instanceof JsfArraySuffix);
    }

    public static class JsfPropertySuffix
    extends PropertySuffix {
        private Application application_;
        private ExpressionProcessor processor_;

        public JsfPropertySuffix(PropertySuffix propertySuffix, Application application, ExpressionProcessor processor) {
            super(propertySuffix.getName());
            this.application_ = application;
            this.processor_ = processor;
        }

        public Object evaluate(Object base, VariableResolver resolver, FunctionMapper mapper, Logger logger) throws ELException {
            if (base == null) {
                return null;
            }
            String indexValue = this.getName();
            if (indexValue == null) {
                return null;
            }
            Integer index = this.processor_.toIndex(base, indexValue);
            return PropertyResolverUtil.getValue(this.application_, base, indexValue, index);
        }
    }

    public static class JsfArraySuffix
    extends ArraySuffix {
        private Application application_;
        private ExpressionProcessor processor_;

        public JsfArraySuffix(ArraySuffix suffix, Application application, ExpressionProcessor processor) {
            super(suffix.getIndex());
            Expression o = this.getIndex();
            this.processor_ = processor;
            this.application_ = application;
            this.processor_.processExpression(o, o.getClass());
        }

        public Object evaluate(Object base, VariableResolver resolver, FunctionMapper mapper, Logger logger) throws ELException {
            if (base == null) {
                return null;
            }
            Object indexValue = this.getIndex().evaluate(resolver, mapper, logger);
            if (indexValue == null) {
                return null;
            }
            Integer index = this.processor_.toIndex(base, indexValue);
            return PropertyResolverUtil.getValue(this.application_, base, indexValue, index);
        }
    }
}

