/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.config.faces.element.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.seasar.framework.util.AssertionUtil;
import org.seasar.teeda.core.config.faces.element.ApplicationElement;
import org.seasar.teeda.core.config.faces.element.ComponentElement;
import org.seasar.teeda.core.config.faces.element.ConverterElement;
import org.seasar.teeda.core.config.faces.element.FacesConfig;
import org.seasar.teeda.core.config.faces.element.FactoryElement;
import org.seasar.teeda.core.config.faces.element.LifecycleElement;
import org.seasar.teeda.core.config.faces.element.ManagedBeanElement;
import org.seasar.teeda.core.config.faces.element.NavigationRuleElement;
import org.seasar.teeda.core.config.faces.element.ReferencedBeanElement;
import org.seasar.teeda.core.config.faces.element.RenderKitElement;
import org.seasar.teeda.core.config.faces.element.RendererElement;
import org.seasar.teeda.core.config.faces.element.ValidatorElement;

public class FacesConfigWrapperImpl
implements FacesConfig {
    private List applications_ = new LinkedList();
    private List factories_ = new LinkedList();
    private List lifecycles_ = new LinkedList();
    private List referencedBeans_ = new LinkedList();
    private List navigationRules_ = new LinkedList();
    private Map components_ = new HashMap();
    private Map convertersByIds_ = new HashMap();
    private Map convertersByClasses_ = new HashMap();
    private Map managedBeans_ = new HashMap();
    private Map renderKits_ = new HashMap();
    private Map validators_ = new HashMap();

    public FacesConfigWrapperImpl(List facesConfigs) {
        AssertionUtil.assertNotNull((String)"facesConfig is null.", (Object)facesConfigs);
        this.deployAllFacesConfig(facesConfigs);
    }

    public void addApplicationElement(ApplicationElement application) {
        this.applications_.add(application);
    }

    public void addFactoryElement(FactoryElement factory) {
        this.factories_.add(factory);
    }

    public void addComponentElement(ComponentElement component) {
        this.components_.put(component.getComponentType(), component);
    }

    public void addConverterElement(ConverterElement converter) {
        if (converter.getConverterId() != null) {
            this.convertersByIds_.put(converter.getConverterId(), converter);
        } else if (converter.getConverterForClass() != null) {
            this.convertersByClasses_.put(converter.getConverterForClass(), converter);
        }
    }

    public void addManagedBeanElement(ManagedBeanElement managedBean) {
        this.managedBeans_.put(managedBean.getManagedBeanName(), managedBean);
    }

    public void addNavigationRuleElement(NavigationRuleElement navigationRule) {
        this.navigationRules_.add(navigationRule);
    }

    public void addRenderKitElement(RenderKitElement renderKit) {
        this.renderKits_.put(renderKit.getRenderKitId(), renderKit);
    }

    public void addLifecycleElement(LifecycleElement lifecycle) {
        this.lifecycles_.add(lifecycle);
    }

    public void addValidatorElement(ValidatorElement validator) {
        this.validators_.put(validator.getValidatorId(), validator);
    }

    public void addReferencedBeanElement(ReferencedBeanElement referencedBean) {
        this.referencedBeans_.add(referencedBean);
    }

    public List getApplicationElements() {
        return this.applications_;
    }

    public List getFactoryElements() {
        return this.factories_;
    }

    public List getLifecycleElements() {
        return this.lifecycles_;
    }

    public Map getComponentElements() {
        return this.components_;
    }

    public Map getManagedBeanElements() {
        return this.managedBeans_;
    }

    public List getNavigationRuleElements() {
        return this.navigationRules_;
    }

    public Map getRenderKitElements() {
        return this.renderKits_;
    }

    public Map getValidatorElements() {
        return this.validators_;
    }

    public Map getConverterElementsById() {
        return this.convertersByIds_;
    }

    public Map getConverterElementsByClass() {
        return this.convertersByClasses_;
    }

    public List getReferencedBeanElements() {
        return this.referencedBeans_;
    }

    private void deployAllFacesConfig(List facesConfigs) {
        Iterator itr = facesConfigs.iterator();
        while (itr.hasNext()) {
            Object o = itr.next();
            if (!(o instanceof FacesConfig)) continue;
            FacesConfig config = (FacesConfig)o;
            this.deployFacesConfig(config);
        }
    }

    private void deployFacesConfig(FacesConfig facesConfig) {
        this.factories_.addAll(facesConfig.getFactoryElements());
        this.applications_.addAll(facesConfig.getApplicationElements());
        this.lifecycles_.addAll(facesConfig.getLifecycleElements());
        this.referencedBeans_.addAll(facesConfig.getReferencedBeanElements());
        this.components_.putAll(facesConfig.getComponentElements());
        this.convertersByIds_.putAll(facesConfig.getConverterElementsById());
        this.convertersByClasses_.putAll(facesConfig.getConverterElementsByClass());
        this.managedBeans_.putAll(facesConfig.getManagedBeanElements());
        this.navigationRules_.addAll(facesConfig.getNavigationRuleElements());
        this.deployRenderKitElements(facesConfig.getRenderKitElements());
        this.validators_.putAll(facesConfig.getValidatorElements());
    }

    private void deployRenderKitElements(Map renderKitElements) {
        Iterator it = renderKitElements.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String renderKitId = (String)entry.getKey();
            RenderKitElement renderKitElement = (RenderKitElement)entry.getValue();
            RenderKitElement earlier = (RenderKitElement)this.renderKits_.get(renderKitId);
            if (earlier != null) {
                this.mergeRenderKitElement(earlier, renderKitElement);
                continue;
            }
            this.renderKits_.put(renderKitId, renderKitElement);
        }
    }

    private void mergeRenderKitElement(RenderKitElement earlier, RenderKitElement renderKitElement) {
        String renderKitClass = renderKitElement.getRenderKitClass();
        if (renderKitClass != null) {
            earlier.setRenderKitClass(renderKitClass);
        }
        Iterator it = renderKitElement.getRendererElements().iterator();
        while (it.hasNext()) {
            RendererElement rendererElement = (RendererElement)it.next();
            earlier.addRendererElement(rendererElement);
        }
    }
}

