/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.unit.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntrospectorUtil {
    public static List<Method> getAnnotatedMethods(Class<?> clazz, Class<? extends Annotation> annotationClass) {
        ArrayList<Method> results = new ArrayList<Method>();
        for (Class<?> eachClass : IntrospectorUtil.getSuperClasses(clazz)) {
            Method[] methods;
            for (Method eachMethod : methods = eachClass.getDeclaredMethods()) {
                Annotation annotation = eachMethod.getAnnotation(annotationClass);
                if (annotation == null || IntrospectorUtil.isShadowed(eachMethod, results)) continue;
                results.add(eachMethod);
            }
        }
        return results;
    }

    public static List<Class<?>> getSuperClasses(Class<?> clazz) {
        ArrayList results = new ArrayList();
        for (Class<?> current = clazz; current != null && current != Object.class; current = current.getSuperclass()) {
            results.add(current);
        }
        return results;
    }

    public static boolean isShadowed(Method method, List<Method> results) {
        for (Method each : results) {
            if (!IntrospectorUtil.isShadowed(method, each)) continue;
            return true;
        }
        return false;
    }

    protected static boolean isShadowed(Method current, Method previous) {
        if (!previous.getName().equals(current.getName())) {
            return false;
        }
        if (previous.getParameterTypes().length != current.getParameterTypes().length) {
            return false;
        }
        for (int i = 0; i < previous.getParameterTypes().length; ++i) {
            if (previous.getParameterTypes()[i].equals(current.getParameterTypes()[i])) continue;
            return false;
        }
        return true;
    }
}

