/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.render.html;

import java.io.IOException;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlCommandButton;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.FacesEvent;
import javax.faces.internal.LabelUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.core.render.RenderPreparableRenderer;
import org.seasar.teeda.core.render.html.HtmlCommandButtonRenderer;
import org.seasar.teeda.core.util.RendererUtil;
import org.seasar.teeda.extension.component.TForEach;
import org.seasar.teeda.extension.component.html.THtmlCommandButton;
import org.seasar.teeda.extension.event.TActionEvent;
import org.seasar.teeda.extension.util.DoubleSubmitProtectionLoader;
import org.seasar.teeda.extension.util.KumuDisabledScriptLoader;
import org.seasar.teeda.extension.util.PathUtil;
import org.seasar.teeda.extension.util.TransactionTokenUtil;

public class THtmlCommandButtonRenderer
extends HtmlCommandButtonRenderer
implements RenderPreparableRenderer {
    public static final String COMPONENT_FAMILY = "javax.faces.Command";
    public static final String RENDERER_TYPE = "org.seasar.teeda.extension.HtmlCommandButton";
    public static final String loader_BINDING = "bindingType=may";
    private DoubleSubmitProtectionLoader loader = new KumuDisabledScriptLoader();

    public THtmlCommandButtonRenderer() {
        this.addIgnoreAttributeName("renderJs");
        this.addIgnoreAttributeName("time");
        this.addIgnoreAttributeName("baseViewId");
    }

    protected void enqueueEvent(HtmlCommandButton htmlCommandButton) {
        TActionEvent event = new TActionEvent((UIComponent)htmlCommandButton);
        for (UIComponent component = htmlCommandButton.getParent(); component != null; component = component.getParent()) {
            if (!(component instanceof TForEach)) continue;
            TForEach forEach = (TForEach)component;
            event.addIndex(forEach, forEach.getRowIndex());
        }
        htmlCommandButton.queueEvent((FacesEvent)event);
    }

    public void encodeBefore(FacesContext context, UIComponent component) throws IOException {
        this.assertNotNull(context, component);
        if (!component.isRendered()) {
            return;
        }
        String id = component.getId();
        if (TransactionTokenUtil.isDoOnce(id)) {
            this.encodeTHtmlCommandButtonPrepare(context, (THtmlCommandButton)component);
        }
    }

    protected void encodeTHtmlCommandButtonPrepare(FacesContext context, THtmlCommandButton button) throws IOException {
        if (!button.isRenderJs()) {
            return;
        }
        this.loader.loadScript(context, button);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        super.encodeEnd(context, component);
        if (!component.isRendered()) {
            return;
        }
        if (!TransactionTokenUtil.isDoOnce(component.getId())) {
            return;
        }
        TransactionTokenUtil.renderTokenIfNeed(context, component);
    }

    protected String getImage(FacesContext context, HtmlCommandButton htmlCommandButton) {
        String image = super.getImage(context, htmlCommandButton);
        if (StringUtil.isEmpty((String)image)) {
            return image;
        }
        String baseViewId = ((THtmlCommandButton)htmlCommandButton).getBaseViewId();
        return PathUtil.toAbsolutePath(context, image, baseViewId);
    }

    protected void renderValueAttribute(FacesContext context, UICommand command, ResponseWriter writer) throws IOException {
        String id = this.getIdForRender(context, (UIComponent)command);
        String labelValue = LabelUtil.getLabelValue((String)id);
        if (labelValue != null) {
            RendererUtil.renderAttribute((ResponseWriter)writer, (String)"value", (Object)labelValue);
        } else {
            super.renderValueAttribute(context, command, writer);
        }
    }

    public DoubleSubmitProtectionLoader getLoader() {
        return this.loader;
    }

    public void setLoader(DoubleSubmitProtectionLoader loader) {
        this.loader = loader;
    }
}

