/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.config.faces.element.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.seasar.teeda.core.config.faces.element.ApplicationElement;
import org.seasar.teeda.core.config.faces.element.ComponentElement;
import org.seasar.teeda.core.config.faces.element.ConverterElement;
import org.seasar.teeda.core.config.faces.element.FacesConfig;
import org.seasar.teeda.core.config.faces.element.FactoryElement;
import org.seasar.teeda.core.config.faces.element.LifecycleElement;
import org.seasar.teeda.core.config.faces.element.ManagedBeanElement;
import org.seasar.teeda.core.config.faces.element.NavigationRuleElement;
import org.seasar.teeda.core.config.faces.element.ReferencedBeanElement;
import org.seasar.teeda.core.config.faces.element.RenderKitElement;
import org.seasar.teeda.core.config.faces.element.RendererElement;
import org.seasar.teeda.core.config.faces.element.ValidatorElement;

public class FacesConfigImpl
implements FacesConfig {
    private List applications_ = new ArrayList();
    private List factories_ = new ArrayList();
    private List lifecycles_ = new ArrayList();
    private List referencedBeans_ = new ArrayList();
    private List navigationRules_ = new ArrayList();
    private Map components_ = new HashMap();
    private Map convertersByIds_ = new HashMap();
    private Map convertersByClasses_ = new HashMap();
    private Map managedBeans_ = new HashMap();
    private Map renderKits_ = new HashMap();
    private Map validators_ = new HashMap();

    public void addApplicationElement(ApplicationElement application) {
        this.applications_.add(application);
    }

    public void addFactoryElement(FactoryElement factory) {
        this.factories_.add(factory);
    }

    public void addComponentElement(ComponentElement component) {
        this.components_.put(component.getComponentType(), component);
    }

    public void addConverterElement(ConverterElement converter) {
        if (converter.getConverterId() != null) {
            this.convertersByIds_.put(converter.getConverterId(), converter);
        } else if (converter.getConverterForClass() != null) {
            this.convertersByClasses_.put(converter.getConverterForClass(), converter);
        }
    }

    public void addManagedBeanElement(ManagedBeanElement managedBean) {
        this.managedBeans_.put(managedBean.getManagedBeanName(), managedBean);
    }

    public void addNavigationRuleElement(NavigationRuleElement navigationRule) {
        this.navigationRules_.add(navigationRule);
    }

    public void addRenderKitElement(RenderKitElement renderKit) {
        String renderKitId = renderKit.getRenderKitId();
        RenderKitElement renderKitElement = (RenderKitElement)this.renderKits_.get(renderKitId);
        if (renderKitElement == null) {
            this.renderKits_.put(renderKitId, renderKit);
        } else {
            List elements = renderKit.getRendererElements();
            int size = elements.size();
            for (int i = 0; i < size; ++i) {
                RendererElement element = (RendererElement)elements.get(i);
                renderKitElement.addRendererElement(element);
            }
        }
    }

    public void addLifecycleElement(LifecycleElement lifecycle) {
        this.lifecycles_.add(lifecycle);
    }

    public void addValidatorElement(ValidatorElement validator) {
        this.validators_.put(validator.getValidatorId(), validator);
    }

    public void addReferencedBeanElement(ReferencedBeanElement referencedBean) {
        this.referencedBeans_.add(referencedBean);
    }

    public List getApplicationElements() {
        return this.applications_;
    }

    public List getFactoryElements() {
        return this.factories_;
    }

    public List getLifecycleElements() {
        return this.lifecycles_;
    }

    public Map getComponentElements() {
        return this.components_;
    }

    public Map getManagedBeanElements() {
        return this.managedBeans_;
    }

    public List getNavigationRuleElements() {
        return this.navigationRules_;
    }

    public Map getRenderKitElements() {
        return this.renderKits_;
    }

    public Map getValidatorElements() {
        return this.validators_;
    }

    public Map getConverterElementsById() {
        return this.convertersByIds_;
    }

    public Map getConverterElementsByClass() {
        return this.convertersByClasses_;
    }

    public List getReferencedBeanElements() {
        return this.referencedBeans_;
    }
}

