/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.render.html;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlOutputText;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.seasar.teeda.core.render.html.HtmlOutputTextRenderer;
import org.seasar.teeda.core.util.RendererUtil;
import org.seasar.teeda.core.util.ValueHolderUtil;
import org.seasar.teeda.extension.component.html.THtmlOutputText;

public class THtmlOutputTextRenderer
extends HtmlOutputTextRenderer {
    public static final String COMPONENT_FAMILY = "javax.faces.Output";
    public static final String RENDERER_TYPE = "org.seasar.teeda.extension.HtmlOutputText";

    public THtmlOutputTextRenderer() {
        this.addIgnoreAttributeName("tagName");
        this.addIgnoreAttributeName("invisible");
        this.addIgnoreAttributeName("omittag");
    }

    protected void encodeHtmlOutputTextEnd(FacesContext context, HtmlOutputText htmlOutputText) throws IOException {
        THtmlOutputText text = (THtmlOutputText)htmlOutputText;
        ResponseWriter writer = context.getResponseWriter();
        String id = this.getIdForRender(context, (UIComponent)htmlOutputText);
        boolean renderTag = false;
        boolean invisible = text.isInvisible();
        boolean omittag = text.isOmittag();
        if (this.containsAttributeForRender((UIComponent)htmlOutputText, this.getIgnoreAttribute()) && !invisible && !omittag) {
            writer.startElement(text.getTagName(), (UIComponent)htmlOutputText);
            renderTag = true;
            RendererUtil.renderIdAttributeIfNecessary((ResponseWriter)writer, (UIComponent)htmlOutputText, (String)id);
            this.renderRemainAttributes((UIComponent)htmlOutputText, writer, this.getIgnoreAttribute());
        }
        String value = ValueHolderUtil.getValueForRender((FacesContext)context, (UIComponent)htmlOutputText);
        if (htmlOutputText.isEscape()) {
            writer.writeText((Object)value, null);
        } else {
            writer.write(value);
        }
        if (renderTag) {
            writer.endElement(text.getTagName());
        }
    }
}

