/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.portlet;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.PortalContext;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.WindowState;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.portlet.PortletFileUpload;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.ArrayUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.extension.util.ExternalMessageUtil;

public class MultipartFormDataActionRequestWrapper
implements ActionRequest {
    public static final String WWW_FORM_URLENCODED_TYPE = "application/x-www-form-urlencoded";
    private static final Logger logger = Logger.getLogger((Class)MultipartFormDataActionRequestWrapper.class);
    protected PortletFileUpload fileUpload;
    protected Map parameters = new HashMap(64);
    protected Map fileItems = new HashMap(64);
    protected String encoding = null;
    private ActionRequest request;

    public MultipartFormDataActionRequestWrapper(ActionRequest request, int maxSize, int maxFileSize, int thresholdSize, String repositoryPath, String encoding) {
        this.request = request;
        DiskFileItemFactory factory = new DiskFileItemFactory();
        factory.setSizeThreshold(thresholdSize);
        if (!StringUtil.isEmpty((String)repositoryPath)) {
            factory.setRepository(new File(repositoryPath));
        }
        this.fileUpload = new PortletFileUpload((FileItemFactory)factory);
        this.fileUpload.setSizeMax((long)maxSize);
        this.fileUpload.setFileSizeMax((long)maxFileSize);
        this.encoding = encoding;
        this.parseRequest(request);
    }

    protected void parseRequest(ActionRequest request) {
        try {
            String enc = this.encoding;
            if (enc == null) {
                enc = request.getCharacterEncoding();
            }
            List requestParameters = this.fileUpload.parseRequest(request);
            Iterator it = requestParameters.iterator();
            while (it.hasNext()) {
                FileItem fileItem = (FileItem)it.next();
                if (fileItem.isFormField()) {
                    String name = fileItem.getFieldName();
                    String value = fileItem.getString(enc);
                    this.addParameter(name, value);
                    continue;
                }
                this.fileItems.put(fileItem.getFieldName(), fileItem);
            }
        }
        catch (FileUploadBase.SizeLimitExceededException e) {
            logger.log("ETDA0110", new Object[0], (Throwable)e);
            ExternalMessageUtil.addMessage((PortletRequest)request, "org.seasar.teeda.extension.component.THtmlFileUpload.SIZE_ERROR", new Object[]{new Long(e.getPermittedSize()), new Long(e.getActualSize())});
        }
        catch (FileUploadBase.FileSizeLimitExceededException e) {
            logger.log("ETDA0110", new Object[0], (Throwable)e);
            ExternalMessageUtil.addMessage((PortletRequest)request, "org.seasar.teeda.extension.component.THtmlFileUpload.FILE_SIZE_ERROR", new Object[]{new Long(e.getPermittedSize()), new Long(e.getActualSize())});
        }
        catch (Exception e) {
            logger.log("ETDA0110", new Object[0], (Throwable)e);
            ExternalMessageUtil.addMessage((PortletRequest)request, "org.seasar.teeda.extension.component.THtmlFileUpload.ERROR");
        }
        Iterator it = request.getParameterMap().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String name = (String)entry.getKey();
            String[] values = (String[])entry.getValue();
            this.addParameters(name, values);
        }
    }

    public Enumeration getParameterNames() {
        return Collections.enumeration(this.parameters.keySet());
    }

    public String getParameter(String name) {
        String[] values = (String[])this.parameters.get(name);
        return values == null ? null : values[0];
    }

    public String[] getParameterValues(String name) {
        return (String[])this.parameters.get(name);
    }

    public Map getParameterMap() {
        return this.parameters;
    }

    public Object getAttribute(String string) {
        if ("org.seasar.teeda.core.filter.MultipartFormData.itemFiles".equals(string)) {
            return this.getFileItems();
        }
        return this.request.getAttribute(string);
    }

    public String getContentType() {
        return WWW_FORM_URLENCODED_TYPE;
    }

    public FileItem getFileItem(String fieldName) {
        return (FileItem)this.fileItems.get(fieldName);
    }

    public Map getFileItems() {
        return this.fileItems;
    }

    protected void addParameter(String name, String value) {
        if (!this.parameters.containsKey(name)) {
            this.parameters.put(name, new String[]{value});
        } else {
            Object[] oldValues = (String[])this.parameters.get(name);
            String[] newValues = (String[])ArrayUtil.add((Object[])oldValues, (Object)value);
            this.parameters.put(name, newValues);
        }
    }

    protected void addParameters(String name, String[] values) {
        if (!this.parameters.containsKey(name)) {
            this.parameters.put(name, values);
        } else {
            Object[] oldValues = (String[])this.parameters.get(name);
            String[] newValues = (String[])ArrayUtil.add((Object[])oldValues, (Object[])values);
            this.parameters.put(name, newValues);
        }
    }

    public String getCharacterEncoding() {
        if (this.encoding != null) {
            return this.encoding;
        }
        return this.request.getCharacterEncoding();
    }

    public Enumeration getAttributeNames() {
        return this.request.getAttributeNames();
    }

    public String getAuthType() {
        return this.request.getAuthType();
    }

    public int getContentLength() {
        return this.request.getContentLength();
    }

    public String getContextPath() {
        return this.request.getContextPath();
    }

    public Locale getLocale() {
        return this.request.getLocale();
    }

    public Enumeration getLocales() {
        return this.request.getLocales();
    }

    public PortalContext getPortalContext() {
        return this.request.getPortalContext();
    }

    public InputStream getPortletInputStream() throws IOException {
        return this.request.getPortletInputStream();
    }

    public PortletMode getPortletMode() {
        return this.request.getPortletMode();
    }

    public PortletSession getPortletSession() {
        return this.request.getPortletSession();
    }

    public PortletSession getPortletSession(boolean arg0) {
        return this.request.getPortletSession(arg0);
    }

    public PortletPreferences getPreferences() {
        return this.request.getPreferences();
    }

    public Enumeration getProperties(String arg0) {
        return this.request.getProperties(arg0);
    }

    public String getProperty(String arg0) {
        return this.request.getProperty(arg0);
    }

    public Enumeration getPropertyNames() {
        return this.request.getPropertyNames();
    }

    public BufferedReader getReader() throws UnsupportedEncodingException, IOException {
        return this.request.getReader();
    }

    public String getRemoteUser() {
        return this.request.getRemoteUser();
    }

    public String getRequestedSessionId() {
        return this.request.getRequestedSessionId();
    }

    public String getResponseContentType() {
        return this.request.getResponseContentType();
    }

    public Enumeration getResponseContentTypes() {
        return this.request.getResponseContentTypes();
    }

    public String getScheme() {
        return this.request.getScheme();
    }

    public String getServerName() {
        return this.request.getServerName();
    }

    public int getServerPort() {
        return this.request.getServerPort();
    }

    public Principal getUserPrincipal() {
        return this.request.getUserPrincipal();
    }

    public WindowState getWindowState() {
        return this.request.getWindowState();
    }

    public boolean isPortletModeAllowed(PortletMode arg0) {
        return this.request.isPortletModeAllowed(arg0);
    }

    public boolean isRequestedSessionIdValid() {
        return this.request.isRequestedSessionIdValid();
    }

    public boolean isSecure() {
        return this.request.isSecure();
    }

    public boolean isUserInRole(String arg0) {
        return this.request.isUserInRole(arg0);
    }

    public boolean isWindowStateAllowed(WindowState arg0) {
        return this.request.isWindowStateAllowed(arg0);
    }

    public void removeAttribute(String arg0) {
        this.request.removeAttribute(arg0);
    }

    public void setAttribute(String arg0, Object arg1) {
        this.request.setAttribute(arg0, arg1);
    }

    public void setCharacterEncoding(String arg0) throws UnsupportedEncodingException {
        this.request.setCharacterEncoding(arg0);
    }

    public ActionRequest getRequest() {
        return this.request;
    }
}

