/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.html.factory;

import java.util.Map;
import org.seasar.teeda.extension.html.ActionDesc;
import org.seasar.teeda.extension.html.ElementNode;
import org.seasar.teeda.extension.html.PageDesc;
import org.seasar.teeda.extension.html.factory.AbstractElementProcessorFactory;

public class SelectBooleanCheckboxFactory
extends AbstractElementProcessorFactory {
    private static final String TAG_NAME = "selectBooleanCheckbox";

    public boolean isMatch(ElementNode elementNode, PageDesc pageDesc, ActionDesc actionDesc) {
        if (!"input".equalsIgnoreCase(elementNode.getTagName())) {
            return false;
        }
        String id = elementNode.getId();
        if (id == null) {
            return false;
        }
        if (!"checkbox".equalsIgnoreCase(elementNode.getProperty("type"))) {
            return false;
        }
        if (pageDesc == null) {
            return false;
        }
        return pageDesc.hasProperty(elementNode.getId());
    }

    protected void customizeProperties(Map properties, ElementNode elementNode, PageDesc pageDesc, ActionDesc actionDesc) {
        super.customizeProperties(properties, elementNode, pageDesc, actionDesc);
        if (pageDesc != null) {
            properties.put("value", this.getBindingExpression(pageDesc.getPageName(), elementNode.getId()));
        }
    }

    protected String getUri() {
        return "http://www.seasar.org/teeda/extension";
    }

    protected String getTagName() {
        return TAG_NAME;
    }
}

