/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.internal;

import java.util.Map;
import javax.faces.internal.EnumUtil;
import javax.faces.internal.ValidatorBuilder;
import javax.faces.internal.ValidatorChain;
import javax.faces.internal.ValidatorResource;
import javax.faces.validator.Validator;
import org.seasar.framework.beans.util.BeanUtil;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.framework.container.hotdeploy.HotdeployUtil;

public class HotDeployValidatorBuilderImpl
implements ValidatorBuilder {
    private S2Container container;

    public HotDeployValidatorBuilderImpl() {
        this.container = SingletonS2ContainerFactory.getContainer();
    }

    public HotDeployValidatorBuilderImpl(S2Container container) {
        this.container = container;
    }

    public Validator build(String expression, ValidatorResource.ValidatorPair[] pairs) {
        if (pairs == null || pairs.length == 0) {
            return null;
        }
        if (pairs.length == 1) {
            return this.getSingleValidator(pairs[0]);
        }
        ValidatorChain chain = new ValidatorChain();
        for (int i = 0; i < pairs.length; ++i) {
            chain.add(this.getSingleValidator(pairs[i]));
        }
        return chain;
    }

    protected Validator getSingleValidator(ValidatorResource.ValidatorPair pair) {
        Map properties = pair.properties;
        if (HotdeployUtil.isHotdeploy()) {
            properties = EnumUtil.convertNameToEnum(properties);
        }
        Validator validator = (Validator)this.container.getComponent((Object)pair.validatorName);
        BeanUtil.copyProperties((Map)properties, (Object)validator);
        return validator;
    }

    public void setContainer(S2Container container) {
        this.container = container;
    }

    public void clearAll() {
    }

    public void clearValidator(String expression) {
    }
}

