/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.internal;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.internal.ComponentStatesHolder;
import javax.faces.internal.NamingContainerUtil;
import javax.faces.internal.SavedState;

public class ComponentStates {
    public static final int DEFAULT_INITIAL_CAPACITY = 1024;
    private Map savedStates;

    public ComponentStates() {
        this(1024);
    }

    public ComponentStates(int initialCapacity) {
        this.savedStates = new HashMap(initialCapacity);
    }

    public void restoreDescendantState(FacesContext context, UIComponent component) {
        Iterator it = component.getFacetsAndChildren();
        while (it.hasNext()) {
            SavedState state;
            String clientId;
            Object holder;
            UIComponent child = (UIComponent)it.next();
            NamingContainerUtil.refreshClientId(child);
            if (child instanceof ComponentStatesHolder) {
                holder = (ComponentStatesHolder)((Object)child);
                clientId = child.getClientId(context);
                state = (SavedState)this.savedStates.get(clientId);
                if (state == null) {
                    state = new SavedState();
                    this.savedStates.put(clientId, state);
                }
                state.restore((ComponentStatesHolder)holder);
                continue;
            }
            if (child instanceof EditableValueHolder) {
                holder = (EditableValueHolder)((Object)child);
                clientId = child.getClientId(context);
                state = (SavedState)this.savedStates.get(clientId);
                if (state == null) {
                    state = new SavedState();
                    this.savedStates.put(clientId, state);
                }
                state.restore((EditableValueHolder)holder);
            }
            this.restoreDescendantState(context, child);
        }
    }

    public void saveDescendantComponentStates(FacesContext context, UIComponent component) {
        Iterator it = component.getFacetsAndChildren();
        while (it.hasNext()) {
            String clientId;
            SavedState state;
            Object holder;
            UIComponent child = (UIComponent)it.next();
            if (child instanceof ComponentStatesHolder) {
                holder = (ComponentStatesHolder)((Object)child);
                state = new SavedState();
                clientId = child.getClientId(context);
                state.save((ComponentStatesHolder)holder);
                this.savedStates.put(clientId, state);
                continue;
            }
            if (child instanceof EditableValueHolder) {
                holder = (EditableValueHolder)((Object)child);
                state = new SavedState();
                clientId = child.getClientId(context);
                state.save((EditableValueHolder)holder);
                this.savedStates.put(clientId, state);
            }
            this.saveDescendantComponentStates(context, child);
        }
    }

    public Map getSavedStates() {
        return this.savedStates;
    }

    public void clear() {
        this.savedStates.clear();
    }
}

