/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.model;

import javax.faces.model.DataModel;
import javax.faces.model.DataModelEvent;
import javax.faces.model.DataModelListener;

public class ScalarDataModel
extends DataModel {
    private Object scalar = null;
    private int index = -1;

    public ScalarDataModel() {
        this(null);
    }

    public ScalarDataModel(Object scalar) {
        this.setWrappedData(scalar);
    }

    public int getRowCount() {
        return this.scalar != null ? 1 : -1;
    }

    public Object getRowData() {
        if (this.scalar == null) {
            return null;
        }
        if (!this.isRowAvailable()) {
            throw new IllegalArgumentException();
        }
        return this.scalar;
    }

    public int getRowIndex() {
        return this.scalar != null ? 0 : -1;
    }

    public Object getWrappedData() {
        return this.scalar;
    }

    public boolean isRowAvailable() {
        if (this.scalar == null) {
            return false;
        }
        return this.index == 0;
    }

    public void setRowIndex(int rowIndex) {
        if (rowIndex < -1) {
            throw new IllegalArgumentException();
        }
        int oldIndex = this.index;
        this.index = rowIndex;
        if (this.scalar == null) {
            return;
        }
        DataModelListener[] listeners = this.getDataModelListeners();
        if (oldIndex != this.index && listeners != null) {
            DataModelEvent event = new DataModelEvent(this, this.index, this.scalar);
            for (int i = 0; i < listeners.length; ++i) {
                listeners[i].rowSelected(event);
            }
        }
    }

    public void setWrappedData(Object data) {
        if (data == null) {
            this.scalar = null;
            this.setRowIndex(-1);
        } else {
            this.scalar = data;
            this.setRowIndex(0);
        }
    }
}

