/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.html.impl;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.hotdeploy.HotdeployUtil;
import org.seasar.framework.convention.NamingConvention;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.teeda.extension.html.HtmlSuffix;
import org.seasar.teeda.extension.html.PageDesc;
import org.seasar.teeda.extension.html.PageDescCache;
import org.seasar.teeda.extension.html.impl.PageDescImpl;

public class PageDescCacheImpl
implements PageDescCache {
    private Map pageDescs = new HashMap();
    public static final String namingConvention_BINDING = "bindingType=must";
    private NamingConvention namingConvention;
    private S2Container container;
    private HtmlSuffix htmlSuffix;

    public void setNamingConvention(NamingConvention namingConvention) {
        this.namingConvention = namingConvention;
    }

    public void setContainer(S2Container container) {
        this.container = container;
    }

    public void setHtmlSuffix(HtmlSuffix htmlSuffix) {
        this.htmlSuffix = htmlSuffix;
    }

    public synchronized PageDesc getPageDesc(String viewId) {
        viewId = this.htmlSuffix.normalizePath(viewId);
        return (PageDesc)this.pageDescs.get(viewId);
    }

    public synchronized PageDesc createPageDesc(String viewId) {
        viewId = this.htmlSuffix.normalizePath(viewId);
        String pageName = this.namingConvention.fromPathToPageName(viewId);
        if (!this.container.getRoot().hasComponentDef((Object)pageName)) {
            return null;
        }
        ComponentDef cd = this.container.getRoot().getComponentDef((Object)pageName);
        File file = null;
        if (HotdeployUtil.isHotdeploy()) {
            file = ResourceUtil.getResourceAsFileNoException((Class)cd.getComponentClass());
        }
        PageDescImpl pageDesc = new PageDescImpl(cd.getConcreteClass(), pageName, file);
        this.pageDescs.put(viewId, pageDesc);
        return pageDesc;
    }
}

