/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.taglib;

import javax.faces.component.UIComponent;
import javax.faces.component.ValueHolder;
import javax.faces.convert.Converter;
import javax.faces.internal.WebAppUtil;
import javax.faces.webapp.UIComponentTag;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.seasar.framework.util.ClassUtil;
import org.seasar.teeda.core.util.UIParameterUtil;

public class TConverterTag
extends BodyTagSupport {
    private static final long serialVersionUID = 1L;
    private String converterId;
    private String targetClass;

    public int doStartTag() throws JspException {
        UIComponentTag tag = UIComponentTag.getParentUIComponentTag((PageContext)this.pageContext);
        if (tag == null) {
            throw new JspException("Not nested in a UIComponentTag");
        }
        if (!tag.getCreated()) {
            return 6;
        }
        Converter converter = this.createConverter();
        UIComponent component = tag.getComponentInstance();
        if (component == null || !(component instanceof ValueHolder)) {
            throw new JspException("Component is null or not editable value holder.");
        }
        ValueHolder valueHolder = (ValueHolder)component;
        valueHolder.setConverter(converter);
        this.pageContext.setAttribute("javax.faces.webapp.CONVERTER_STORE_ATTR", (Object)converter, 2);
        return 2;
    }

    public int doEndTag() throws JspException {
        UIComponentTag tag = UIComponentTag.getParentUIComponentTag((PageContext)this.pageContext);
        if (tag == null) {
            throw new JspException("Not nested in a UIComponentTag");
        }
        if (!tag.getCreated()) {
            return 6;
        }
        UIComponent component = tag.getComponentInstance();
        Object attribute = this.pageContext.getAttribute("javax.faces.webapp.CONVERTER_STORE_ATTR", 2);
        if (attribute instanceof Converter) {
            Converter converter = (Converter)attribute;
            UIParameterUtil.saveParametersToInstance((UIComponent)component, (Object)converter);
        }
        this.pageContext.removeAttribute("javax.faces.webapp.CONVERTER_STORE_ATTR", 2);
        return super.doEndTag();
    }

    protected Converter createConverter() throws JspException {
        Converter converter = null;
        converter = this.createConverterById(this.converterId);
        if (converter == null) {
            converter = this.createConverterByClass(this.targetClass);
        }
        return converter;
    }

    protected Converter createConverterById(String converterId) throws JspException {
        try {
            if (UIComponentTag.isValueReference((String)converterId)) {
                converterId = (String)WebAppUtil.getValueFromCreatedValueBinding((String)converterId);
            }
            return WebAppUtil.createConverter((String)converterId);
        }
        catch (Exception e) {
            throw new JspException((Throwable)e);
        }
    }

    protected Converter createConverterByClass(String className) throws JspException {
        try {
            if (UIComponentTag.isValueReference((String)className)) {
                className = (String)WebAppUtil.getValueFromCreatedValueBinding((String)className);
            }
            Class clazz = ClassUtil.forName((String)className);
            return WebAppUtil.createConverter((Class)clazz);
        }
        catch (Exception e) {
            throw new JspException((Throwable)e);
        }
    }

    public void release() {
        this.converterId = null;
        this.targetClass = null;
        super.release();
    }

    public String getConverterId() {
        return this.converterId;
    }

    public void setConverterId(String converterId) {
        this.converterId = converterId;
    }

    public String getTargetClass() {
        return this.targetClass;
    }

    public void setTargetClass(String targetClass) {
        this.targetClass = targetClass;
    }
}

