/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.html.impl;

import org.apache.xerces.parsers.XML11Configuration;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.seasar.framework.util.ClassUtil;
import org.seasar.teeda.extension.html.impl.TeedaSAXParser;
import org.seasar.teeda.extension.html.impl.TeedaXMLConfiguration;
import org.seasar.teeda.extension.html.impl.TeedaXMLFilter;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public interface TeedaXMLReaderFactory {
    public static final String PROPERTY_LEXICAL_HANDLER = "http://xml.org/sax/properties/lexical-handler";
    public static final String FEATURE_NAMESPACE_PREFIXES = "http://xml.org/sax/features/namespace-prefixes";
    public static final String FEATURE_NOTIFY_CHAR_REFS = "http://apache.org/xml/features/scanner/notify-char-refs";
    public static final String FEATURE_NOTIFY_BUILTIN_REFS = "http://apache.org/xml/features/scanner/notify-builtin-refs";

    public XMLReader createXMLReader() throws SAXException;

    public static class HTML
    implements TeedaXMLReaderFactory {
        protected static final String CONFIGURATION_CLASS_NAME = "org.cyberneko.html.HTMLConfiguration";
        protected static final String PROPERTY_DEFAULT_ENCODING = "http://cyberneko.org/html/properties/default-encoding";
        protected static final String PROPERTY_ELEMS = "http://cyberneko.org/html/properties/names/elems";
        protected static final String PROPERTY_ATTRS = "http://cyberneko.org/html/properties/names/attrs";
        protected static final String FEATURE_NOTIFY_HTML_BUILTIN_REFS = "http://cyberneko.org/html/features/scanner/notify-builtin-refs";
        public static final String encoding_BINDING = "bindingType=may";
        protected String encoding = "UTF-8";

        public void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        public XMLReader createXMLReader() throws SAXException {
            XMLParserConfiguration configuration = (XMLParserConfiguration)ClassUtil.newInstance((String)CONFIGURATION_CLASS_NAME);
            TeedaSAXParser parser = new TeedaSAXParser(configuration);
            TeedaXMLFilter filter = new TeedaXMLFilter((XMLReader)((Object)parser));
            filter.setProperty(TeedaXMLReaderFactory.PROPERTY_LEXICAL_HANDLER, filter);
            filter.setProperty(PROPERTY_DEFAULT_ENCODING, this.encoding);
            filter.setProperty(PROPERTY_ELEMS, "match");
            filter.setProperty(PROPERTY_ATTRS, "no-change");
            filter.setFeature(TeedaXMLReaderFactory.FEATURE_NAMESPACE_PREFIXES, true);
            filter.setFeature(FEATURE_NOTIFY_HTML_BUILTIN_REFS, true);
            return filter;
        }
    }

    public static class STRICT
    implements TeedaXMLReaderFactory {
        public XMLReader createXMLReader() throws SAXException {
            XML11Configuration configuration = new XML11Configuration();
            TeedaSAXParser parser = new TeedaSAXParser((XMLParserConfiguration)configuration);
            TeedaXMLFilter filter = new TeedaXMLFilter((XMLReader)((Object)parser));
            filter.setProperty(TeedaXMLReaderFactory.PROPERTY_LEXICAL_HANDLER, filter);
            filter.setFeature(TeedaXMLReaderFactory.FEATURE_NAMESPACE_PREFIXES, true);
            filter.setFeature(TeedaXMLReaderFactory.FEATURE_NOTIFY_CHAR_REFS, true);
            filter.setFeature(TeedaXMLReaderFactory.FEATURE_NOTIFY_BUILTIN_REFS, true);
            return filter;
        }
    }

    public static class CLASSIC
    implements TeedaXMLReaderFactory {
        public XMLReader createXMLReader() throws SAXException {
            TeedaXMLConfiguration configuration = new TeedaXMLConfiguration();
            TeedaSAXParser parser = new TeedaSAXParser((XMLParserConfiguration)configuration);
            TeedaXMLFilter filter = new TeedaXMLFilter((XMLReader)((Object)parser));
            filter.setProperty(TeedaXMLReaderFactory.PROPERTY_LEXICAL_HANDLER, filter);
            filter.setFeature(TeedaXMLReaderFactory.FEATURE_NAMESPACE_PREFIXES, true);
            return filter;
        }
    }

    public static class DEFAULT
    implements TeedaXMLReaderFactory {
        public XMLReader createXMLReader() throws SAXException {
            TeedaXMLConfiguration configuration = new TeedaXMLConfiguration();
            TeedaSAXParser parser = new TeedaSAXParser((XMLParserConfiguration)configuration);
            TeedaXMLFilter filter = new TeedaXMLFilter((XMLReader)((Object)parser));
            filter.setProperty(TeedaXMLReaderFactory.PROPERTY_LEXICAL_HANDLER, filter);
            filter.setFeature(TeedaXMLReaderFactory.FEATURE_NAMESPACE_PREFIXES, true);
            filter.setFeature(TeedaXMLReaderFactory.FEATURE_NOTIFY_CHAR_REFS, true);
            filter.setFeature(TeedaXMLReaderFactory.FEATURE_NOTIFY_BUILTIN_REFS, true);
            return filter;
        }
    }
}

