/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.component;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.UISelectItems;
import javax.faces.context.FacesContext;
import javax.faces.internal.FacesMessageUtil;
import javax.faces.model.SelectItem;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;

public class TUISelectItems
extends UISelectItems {
    private static final String NULL_LABEL_MESSAGE_CODE = "org.seasar.teeda.extension.component.TSelect.NULL_LABEL";
    private String itemLabel = "label";
    private String itemValue = "value";
    private boolean nullLabelRequired = true;
    private static final SelectItem BLANK_SELECT_ITEM = new SelectItem();

    public String getItemLabel() {
        return this.itemLabel;
    }

    public void setItemLabel(String itemLabel) {
        this.itemLabel = itemLabel;
    }

    public String getItemValue() {
        return this.itemValue;
    }

    public void setItemValue(String itemValue) {
        this.itemValue = itemValue;
    }

    public boolean isNullLabelRequired() {
        return this.nullLabelRequired;
    }

    public void setNullLabelRequired(boolean required) {
        this.nullLabelRequired = required;
    }

    public Object getValue() {
        Iterator<Object> it;
        List<Object> value = super.getValue();
        if (value instanceof SelectItem[] || value instanceof SelectItem) {
            return value;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        boolean nullLabelSet = false;
        if (this.nullLabelRequired) {
            SelectItem si = new SelectItem();
            si.setValue((Object)"");
            FacesContext context = this.getFacesContext();
            FacesMessage mes = FacesMessageUtil.getMessage((FacesContext)context, (String)NULL_LABEL_MESSAGE_CODE, null);
            si.setLabel(mes.getSummary());
            list.add(si);
            nullLabelSet = true;
        }
        if (value != null && value.getClass().isArray()) {
            value = Arrays.asList((Object[])value);
        }
        if (value instanceof Collection) {
            Collection valueCollection = value;
            if (!nullLabelSet && valueCollection.size() == 0) {
                list.add(BLANK_SELECT_ITEM);
            } else {
                it = valueCollection.iterator();
                while (it.hasNext()) {
                    Object itemValueValue;
                    Object item = it.next();
                    if (item instanceof SelectItem) {
                        list.add(item);
                        continue;
                    }
                    if (item instanceof Map) {
                        Object itemLabelValue;
                        Map map = (Map)item;
                        SelectItem si = new SelectItem();
                        Object itemValueValue2 = map.get(this.itemValue);
                        if (itemValueValue2 != null) {
                            si.setValue(itemValueValue2);
                        }
                        if ((itemLabelValue = map.get(this.itemLabel)) == null) {
                            itemLabelValue = itemValueValue2;
                        }
                        if (itemLabelValue != null) {
                            si.setLabel(itemLabelValue.toString());
                        }
                        list.add(si);
                        continue;
                    }
                    SelectItem si = new SelectItem();
                    BeanDesc bd = BeanDescFactory.getBeanDesc(item.getClass());
                    PropertyDesc pd = bd.getPropertyDesc(this.itemValue);
                    Object object = itemValueValue = pd.isReadable() ? pd.getValue(item) : null;
                    if (itemValueValue != null) {
                        si.setValue(itemValueValue);
                    }
                    Object itemLabelValue = null;
                    if (bd.hasPropertyDesc(this.itemLabel)) {
                        pd = bd.getPropertyDesc(this.itemLabel);
                        Object object2 = itemLabelValue = pd.isReadable() ? pd.getValue(item) : null;
                    }
                    if (itemLabelValue == null) {
                        itemLabelValue = itemValueValue;
                    }
                    if (itemLabelValue != null) {
                        si.setLabel(itemLabelValue.toString());
                    }
                    list.add(si);
                }
            }
        } else if (value instanceof Map) {
            Map map = (Map)((Object)value);
            if (!nullLabelSet && map.size() == 0) {
                list.add(BLANK_SELECT_ITEM);
            } else {
                it = map.keySet().iterator();
                while (it.hasNext()) {
                    Object key = it.next();
                    Object val = map.get(key);
                    SelectItem si = new SelectItem();
                    if (key != null) {
                        si.setLabel(key.toString());
                    }
                    if (val != null) {
                        si.setValue(val);
                    }
                    list.add(si);
                }
            }
        } else if (!nullLabelSet && value == null) {
            list.add(BLANK_SELECT_ITEM);
        }
        return list;
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.itemValue, this.itemLabel, this.nullLabelRequired};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.itemValue = (String)values[1];
        this.itemLabel = (String)values[2];
        this.nullLabelRequired = (Boolean)values[3];
    }

    static {
        BLANK_SELECT_ITEM.setValue((Object)"");
        BLANK_SELECT_ITEM.setLabel("");
    }
}

