/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.convert;

import java.math.BigDecimal;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.BigDecimalConverter;
import javax.faces.convert.ConverterException;
import javax.faces.internal.ConvertUtil;
import javax.faces.internal.FacesMessageUtil;
import org.seasar.framework.util.AssertionUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.extension.convert.ConvertTargetSelectable;
import org.seasar.teeda.extension.convert.ConverterHelper;
import org.seasar.teeda.extension.util.BigDecimalFormatUtil;
import org.seasar.teeda.extension.util.TargetCommandUtil;

public class TBigDecimalConverter
extends BigDecimalConverter
implements ConvertTargetSelectable,
StateHolder {
    public static final int SCALE_NONE = -1;
    public static final int ROUNDINGMODE_NONE = -1;
    protected String pattern;
    protected Integer scale;
    protected Integer roundingMode;
    protected String target;
    protected String[] targets;
    protected boolean transientValue = false;
    protected String objectMessageId;
    protected String stringMessageId;

    public Object getAsObject(FacesContext context, UIComponent component, String value) throws ConverterException {
        AssertionUtil.assertNotNull((String)"FacesContext", (Object)context);
        AssertionUtil.assertNotNull((String)"UIComponent", (Object)component);
        if (!ConverterHelper.isTargetCommand(context, component, this.targets, this)) {
            return value;
        }
        return super.getAsObject(context, component, value);
    }

    public String getAsString(FacesContext context, UIComponent component, Object value) throws ConverterException {
        AssertionUtil.assertNotNull((String)"FacesContext", (Object)context);
        AssertionUtil.assertNotNull((String)"UIComponent", (Object)component);
        if (value == null) {
            return "";
        }
        try {
            if (value instanceof String) {
                return (String)value;
            }
            if (!this.isTargetCommandConvert(context, this.targets)) {
                return null;
            }
            BigDecimal decimalValue = (BigDecimal)value;
            if (this.scale != null && this.scale != -1) {
                decimalValue = this.roundingMode != null && this.scale != -1 ? decimalValue.setScale((int)this.scale, this.roundingMode) : decimalValue.setScale(this.scale);
            }
            String pattern = this.getPattern();
            return BigDecimalFormatUtil.format(decimalValue, pattern);
        }
        catch (Exception e) {
            Object[] args = ConvertUtil.createExceptionMessageArgs((UIComponent)component, (Object)((String)value));
            throw new ConverterException(FacesMessageUtil.getMessage((FacesContext)context, (String)this.getStringMessageId(), (Object[])args));
        }
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public Integer getScale() {
        return this.scale;
    }

    public void setScale(Integer scale) {
        this.scale = scale;
    }

    public Integer getRoundingMode() {
        return this.roundingMode;
    }

    public void setRoundingMode(Integer roundingMode) {
        this.roundingMode = roundingMode;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
        if (StringUtil.isEmpty((String)target)) {
            return;
        }
        this.targets = StringUtil.split((String)target, (String)", ");
    }

    public boolean isTargetCommandConvert(FacesContext context, String[] targets) {
        return TargetCommandUtil.isTargetCommand(context, targets);
    }

    public String getObjectMessageId() {
        return !StringUtil.isEmpty((String)this.objectMessageId) ? this.objectMessageId : super.getObjectMessageId();
    }

    public void setObjectMessageId(String objectMessageId) {
        this.objectMessageId = objectMessageId;
    }

    public String getStringMessageId() {
        return !StringUtil.isEmpty((String)this.stringMessageId) ? this.stringMessageId : super.getStringMessageId();
    }

    public void setStringMessageId(String stringMessageId) {
        this.stringMessageId = stringMessageId;
    }

    public boolean isTransient() {
        return this.transientValue;
    }

    public void setTransient(boolean transientValue) {
        this.transientValue = transientValue;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this.pattern = (String)values[0];
        this.scale = (Integer)values[1];
        this.roundingMode = (Integer)values[2];
        this.target = (String)values[3];
        this.setTarget(this.target);
        this.objectMessageId = (String)values[4];
        this.stringMessageId = (String)values[5];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{this.pattern, this.scale, this.roundingMode, this.target, this.objectMessageId, this.stringMessageId};
        return values;
    }
}

