/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LikeUtil {
    protected static final Pattern WILDCARD_PATTERN = Pattern.compile("[%_\uff05\uff3f]");
    protected static final Pattern WILDCARD_REPLACEMENT_PATTERN = Pattern.compile("[$%_\uff05\uff3f]");
    protected static final char WILDCARD_ESCAPE_CHAR = '$';
    protected static Pattern wildcardPattern;
    protected static Pattern wildcardReplacementPattern;

    public static Pattern getWildcardPattern() {
        if (wildcardPattern == null) {
            return WILDCARD_PATTERN;
        }
        return wildcardPattern;
    }

    public static void setWildcardPattern(Pattern pattern) {
        wildcardPattern = pattern;
    }

    public static void setWildcardPatternAsString(String pattern) {
        LikeUtil.setWildcardPattern(Pattern.compile(pattern));
    }

    public static Pattern getWildcardReplacementPattern() {
        if (wildcardReplacementPattern == null) {
            return WILDCARD_REPLACEMENT_PATTERN;
        }
        return wildcardReplacementPattern;
    }

    public static void setWildcardReplacementPattern(Pattern pattern) {
        wildcardReplacementPattern = pattern;
    }

    public static void setWildcardReplacementPatternAsString(String pattern) {
        LikeUtil.setWildcardReplacementPattern(Pattern.compile(pattern));
    }

    public static boolean containsWildcard(String likeCondition) {
        Matcher matcher = LikeUtil.getWildcardPattern().matcher(likeCondition);
        return matcher.find();
    }

    public static String escapeWildcard(String likeCondition) {
        Matcher matcher = LikeUtil.getWildcardReplacementPattern().matcher(likeCondition);
        return matcher.replaceAll("\\$$0");
    }
}

