/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.internal;

import java.util.HashMap;
import java.util.Map;
import javax.faces.internal.ValidatorBuilder;
import javax.faces.validator.Validator;
import org.seasar.framework.util.ArrayUtil;

public class ValidatorResource {
    private static Map validatorPairs = new HashMap();
    private static ValidatorBuilder builder;

    protected ValidatorResource() {
    }

    public static synchronized Validator getValidator(String expression) {
        if (builder == null) {
            return null;
        }
        ValidatorPair[] pairs = (ValidatorPair[])validatorPairs.get(expression);
        return builder.build(expression, pairs);
    }

    public static synchronized void addValidator(String expression, String validatorName) {
        ValidatorResource.addValidator(expression, validatorName, new HashMap());
    }

    public static synchronized void addValidator(String expression, String validatorName, Map properties) {
        ValidatorPair pair = new ValidatorPair(validatorName, properties);
        Object[] pairs = (ValidatorPair[])validatorPairs.get(expression);
        if (pairs == null) {
            pairs = new ValidatorPair[]{};
        }
        validatorPairs.put(expression, ArrayUtil.add((Object[])pairs, (Object)pair));
    }

    public static synchronized void removeValidator(String expression) {
        validatorPairs.remove(expression);
        if (builder != null) {
            builder.clearValidator(expression);
        }
    }

    public static void removeAll() {
        validatorPairs.clear();
        if (builder != null) {
            builder.clearAll();
        }
    }

    public static void setValidatorBuilder(ValidatorBuilder vb) {
        builder = vb;
    }

    public static class ValidatorPair {
        public String validatorName;
        public Map properties;

        public ValidatorPair(String validatorName, Map properties) {
            this.validatorName = validatorName;
            this.properties = properties;
        }
    }
}

