/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.html.factory;

import java.util.Map;
import org.seasar.teeda.extension.html.ActionDesc;
import org.seasar.teeda.extension.html.ElementNode;
import org.seasar.teeda.extension.html.PageDesc;
import org.seasar.teeda.extension.html.factory.AbstractElementProcessorFactory;
import org.seasar.teeda.extension.util.SessionSaveUtil;

public class SessionSaveFactory
extends AbstractElementProcessorFactory {
    private static final String TAG_NAME = "sessionSave";

    public boolean isMatch(ElementNode elementNode, PageDesc pageDesc, ActionDesc actionDesc) {
        if (!"input".equalsIgnoreCase(elementNode.getTagName())) {
            return false;
        }
        if (!"hidden".equalsIgnoreCase(elementNode.getProperty("type"))) {
            return false;
        }
        if (pageDesc == null) {
            return false;
        }
        String id = elementNode.getId();
        if (!id.endsWith("SessionSave")) {
            return false;
        }
        String targetId = SessionSaveUtil.convertTargetId(id);
        return pageDesc.hasProperty(targetId);
    }

    protected void customizeProperties(Map properties, ElementNode elementNode, PageDesc pageDesc, ActionDesc actionDesc) {
        super.customizeProperties(properties, elementNode, pageDesc, actionDesc);
        if (pageDesc == null) {
            return;
        }
        String id = elementNode.getId();
        String targetId = SessionSaveUtil.convertTargetId(id);
        properties.put("value", this.getBindingExpression(pageDesc.getPageName(), targetId));
    }

    protected String getTagName() {
        return TAG_NAME;
    }

    protected String getUri() {
        return "http://www.seasar.org/teeda/extension";
    }
}

