/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.html.factory;

import java.util.Map;
import javax.faces.internal.LabelUtil;
import org.seasar.framework.convention.NamingConvention;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.extension.html.ElementNode;
import org.seasar.teeda.extension.html.HtmlNode;
import org.seasar.teeda.extension.html.PageDesc;
import org.seasar.teeda.extension.html.TextNode;

public class LabelFactoryUtil {
    public static void storeLabelAttributesTo(Map properties, ElementNode elementNode, PageDesc pageDesc, NamingConvention nc) {
        if (properties == null || elementNode == null || pageDesc == null) {
            return;
        }
        String pageName = pageDesc.getPageName();
        String propertiesName = LabelUtil.getPropertiesName((NamingConvention)nc, (String)pageName);
        String id = StringUtil.trimSuffix((String)elementNode.getId(), (String)"Label");
        String key = LabelUtil.getLabelKeySuffix((NamingConvention)nc, (String)pageName) + "." + id;
        String defaultPropertiesName = LabelUtil.getDefaultApplicationPropertiesName((NamingConvention)nc, (String)pageName);
        properties.put("key", key);
        properties.put("propertiesName", propertiesName);
        properties.put("defaultKey", id);
        properties.put("defaultPropertiesName", defaultPropertiesName);
    }

    public static void storeTemplateValue(Map properties, ElementNode elementNode) {
        HtmlNode child;
        int childSize = elementNode.getChildSize();
        if (childSize > 0 && (child = elementNode.getChild(0)) instanceof TextNode) {
            TextNode node = (TextNode)child;
            String value = node.getValue();
            properties.put("templateValue", value);
        }
    }
}

