/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.util;

import java.io.IOException;
import java.net.URL;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.seasar.framework.exception.IORuntimeException;
import org.seasar.framework.util.AssertionUtil;
import org.seasar.teeda.core.util.DefaultRedirectUrlResolverImpl;
import org.seasar.teeda.extension.html.RedirectDesc;
import org.seasar.teeda.extension.util.RedirectUtil;

public class ExtensionRedirectUrlResolverImpl
extends DefaultRedirectUrlResolverImpl {
    protected boolean addUniqueKeyParameter = true;
    protected String uniqueKeyParameterName = "te-uniquekey";

    public void setAddUniqueKeyParameter(boolean addUniqueKeyParameter) {
        this.addUniqueKeyParameter = addUniqueKeyParameter;
    }

    public void setUniqueKeyParameterName(String uniqueKeyParameterName) {
        this.uniqueKeyParameterName = uniqueKeyParameterName;
    }

    public String resolveUrl(String contextPath, FacesContext context, HttpServletRequest request, HttpServletResponse response) throws FacesException {
        AssertionUtil.assertNotNull((String)"contextPath", (Object)contextPath);
        RedirectDesc redirectDesc = RedirectUtil.getRedirectDesc();
        String redirectUrl = redirectDesc != null ? this.buildRedirectUrl(contextPath, request, redirectDesc) : super.resolveUrl(contextPath, context, request, response);
        if (!this.addUniqueKeyParameter) {
            return redirectUrl;
        }
        int pos = redirectUrl.lastIndexOf(63);
        if (pos == -1) {
            return redirectUrl + "?" + this.uniqueKeyParameterName + "=" + Long.toHexString(System.currentTimeMillis());
        }
        pos = redirectUrl.indexOf(this.uniqueKeyParameterName + "=", pos + 1);
        if (pos == -1) {
            return redirectUrl + "&" + this.uniqueKeyParameterName + "=" + Long.toHexString(System.currentTimeMillis());
        }
        int pos2 = redirectUrl.indexOf(38, pos += this.uniqueKeyParameterName.length() + 1);
        pos2 = pos2 == -1 ? redirectUrl.length() : pos2;
        return redirectUrl.substring(0, pos) + Long.toHexString(System.currentTimeMillis()) + redirectUrl.substring(pos2);
    }

    protected String buildRedirectUrl(String contextPath, HttpServletRequest request, RedirectDesc redirectDesc) {
        try {
            URL currentUrl = new URL(new String(request.getRequestURL()));
            URL redirectUrl = new URL(redirectDesc.getProtocol(), currentUrl.getHost(), redirectDesc.getPort(), contextPath);
            return redirectUrl.toExternalForm();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }
}

