/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.sql.SQLException;
import java.util.BitSet;
import java.util.Random;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.table.Plan;
import org.h2.table.PlanItem;
import org.h2.table.TableFilter;
import org.h2.util.Permutations;

public class Optimizer {
    private static final int MAX_BRUTE_FORCE_FILTERS = 7;
    private static final int MAX_BRUTE_FORCE = 2000;
    private static final int MAX_GENETIC = 2000;
    private long start;
    private BitSet switched;
    private TableFilter[] filters;
    private Expression condition;
    private Session session;
    private Plan bestPlan;
    private TableFilter topFilter;
    private double cost;
    private Random random;

    private int getMaxBruteForceFilters(int filterCount) {
        int i = 0;
        int j = filterCount;
        int total = filterCount;
        while (j > 0 && total < 2000) {
            total *= --j;
            ++i;
        }
        return i;
    }

    Optimizer(TableFilter[] filters, Expression condition, Session session) {
        this.filters = filters;
        this.condition = condition;
        this.session = session;
    }

    private void calculateBestPlan() throws SQLException {
        this.start = System.currentTimeMillis();
        this.cost = -1.0;
        if (this.filters.length == 1) {
            this.testPlan(this.filters);
        } else if (this.filters.length <= 7) {
            this.calculateBruteForceAll();
        } else {
            this.calculateBruteForceSome();
            this.random = new Random(0L);
            this.calculateGenetic();
        }
    }

    private boolean canStop(int x) {
        if (x % 100 == 0) {
            long t = System.currentTimeMillis() - this.start;
            if (this.cost >= 0.0 && (double)(10L * t) > this.cost) {
                return true;
            }
        }
        return false;
    }

    private void calculateBruteForceAll() throws SQLException {
        Permutations en = new Permutations(this.filters);
        int x = 0;
        while (en.hasMoreElements() && !this.canStop(x)) {
            Object[] f = (Object[])en.nextElement();
            TableFilter[] ftry = new TableFilter[this.filters.length];
            System.arraycopy(f, 0, ftry, 0, this.filters.length);
            this.testPlan(ftry);
            ++x;
        }
    }

    private void calculateBruteForceSome() throws SQLException {
        int bruteForce = this.getMaxBruteForceFilters(this.filters.length);
        TableFilter[] ftry = new TableFilter[this.filters.length];
        Permutations en = new Permutations(this.filters, bruteForce);
        int x = 0;
        while (en.hasMoreElements() && !this.canStop(x)) {
            int i;
            Object[] f = (Object[])en.nextElement();
            System.arraycopy(f, 0, ftry, 0, bruteForce);
            for (i = 0; i < this.filters.length; ++i) {
                this.filters[i].setUsed(false);
            }
            for (i = 0; i < f.length; ++i) {
                ftry[i].setUsed(true);
            }
            for (i = bruteForce; i < this.filters.length; ++i) {
                double costPart = -1.0;
                int bestPart = -1;
                for (int j = 0; j < this.filters.length; ++j) {
                    if (this.filters[j].getUsed()) continue;
                    if (i == this.filters.length - 1) {
                        bestPart = j;
                        break;
                    }
                    ftry[i] = this.filters[j];
                    Plan part = new Plan(ftry, i + 1, this.condition);
                    double costNow = part.calculateCost(this.session);
                    if (!(costPart < 0.0) && !(costNow < costPart)) continue;
                    costPart = costNow;
                    bestPart = j;
                }
                this.filters[bestPart].setUsed(true);
                ftry[i] = this.filters[bestPart];
            }
            this.testPlan(ftry);
            ++x;
        }
    }

    private void calculateGenetic() throws SQLException {
        TableFilter[] fbest = new TableFilter[this.filters.length];
        TableFilter[] ftry = new TableFilter[this.filters.length];
        for (int x = 0; x < 2000 && !this.canStop(x); ++x) {
            boolean generateRandom;
            boolean bl = generateRandom = x % 100 == 0;
            if (!generateRandom) {
                System.arraycopy(fbest, 0, ftry, 0, this.filters.length);
                if (!this.shuffleTwo(ftry)) {
                    generateRandom = true;
                }
            }
            if (generateRandom) {
                this.switched = new BitSet();
                System.arraycopy(this.filters, 0, fbest, 0, this.filters.length);
                this.shuffleAll(fbest);
                System.arraycopy(fbest, 0, ftry, 0, this.filters.length);
            }
            if (!this.testPlan(ftry)) continue;
            this.switched = new BitSet();
            System.arraycopy(ftry, 0, fbest, 0, this.filters.length);
        }
    }

    private boolean testPlan(TableFilter[] ftry) throws SQLException {
        Plan p = new Plan(ftry, ftry.length, this.condition);
        double costNow = p.calculateCost(this.session);
        if (this.cost < 0.0 || costNow < this.cost) {
            this.cost = costNow;
            this.bestPlan = p;
            return true;
        }
        return false;
    }

    private void shuffleAll(TableFilter[] f) {
        for (int i = 0; i < f.length - 1; ++i) {
            int j = i + this.random.nextInt(f.length - i);
            if (j == i) continue;
            TableFilter temp = f[i];
            f[i] = f[j];
            f[j] = temp;
        }
    }

    private boolean shuffleTwo(TableFilter[] f) {
        int i;
        int a = 0;
        int b = 0;
        for (i = 0; i < 20; ++i) {
            int s;
            a = this.random.nextInt(f.length);
            if (a == (b = this.random.nextInt(f.length))) continue;
            if (a < b) {
                int temp = a;
                a = b;
                b = temp;
            }
            if (this.switched.get(s = a * f.length + b)) continue;
            this.switched.set(s);
            break;
        }
        if (i == 20) {
            return false;
        }
        TableFilter temp = f[a];
        f[a] = f[b];
        f[b] = temp;
        return true;
    }

    void optimize() throws SQLException {
        int i;
        this.calculateBestPlan();
        this.bestPlan.removeUnusableIndexConditions();
        TableFilter[] f2 = this.bestPlan.getFilters();
        this.topFilter = f2[0];
        for (i = 0; i < f2.length - 1; ++i) {
            f2[i].addJoin(f2[i + 1], false, null);
        }
        for (i = 0; i < f2.length; ++i) {
            PlanItem item = this.bestPlan.getItem(f2[i]);
            f2[i].setPlanItem(item);
        }
    }

    public TableFilter getTopFilter() {
        return this.topFilter;
    }

    double getCost() {
        return this.cost;
    }
}

