/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.autoregister;

import java.util.ArrayList;
import org.seasar.framework.container.AutoBindingDef;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.InstanceDef;
import org.seasar.framework.container.autoregister.AbstractAutoRegister;
import org.seasar.framework.container.autoregister.AutoNaming;
import org.seasar.framework.container.autoregister.ClassPattern;
import org.seasar.framework.container.autoregister.DefaultAutoNaming;
import org.seasar.framework.container.factory.AnnotationHandler;
import org.seasar.framework.container.factory.AnnotationHandlerFactory;
import org.seasar.framework.util.ClassTraversal;
import org.seasar.framework.util.ClassUtil;

public abstract class AbstractComponentAutoRegister
extends AbstractAutoRegister
implements ClassTraversal.ClassHandler {
    protected static final String CLASS_SUFFIX = ".class";
    private AutoNaming autoNaming = new DefaultAutoNaming();
    private InstanceDef instanceDef;
    private AutoBindingDef autoBindingDef;
    public static final String autoNaming_BINDING = "bindingType=may";
    public static final String instanceDef_BINDING = "bindingType=may";
    public static final String autoBindingDef_BINDING = "bindingType=may";

    public AutoNaming getAutoNaming() {
        return this.autoNaming;
    }

    public void setAutoNaming(AutoNaming autoNaming) {
        this.autoNaming = autoNaming;
    }

    public InstanceDef getInstanceDef() {
        return this.instanceDef;
    }

    public void setInstanceDef(InstanceDef instanceDef) {
        this.instanceDef = instanceDef;
    }

    public void setAutoBindingDef(AutoBindingDef autoBindingDef) {
        this.autoBindingDef = autoBindingDef;
    }

    public void processClass(String packageName, String shortClassName) {
        if (this.isIgnore(packageName, shortClassName)) {
            return;
        }
        for (int i = 0; i < this.getClassPatternSize(); ++i) {
            ClassPattern cp = this.getClassPattern(i);
            if (!cp.isAppliedPackageName(packageName) || !cp.isAppliedShortClassName(shortClassName)) continue;
            this.register(packageName, shortClassName);
            return;
        }
    }

    protected void register(String packageName, String shortClassName) {
        String className;
        AnnotationHandler annoHandler = AnnotationHandlerFactory.getAnnotationHandler();
        ComponentDef cd = annoHandler.createComponentDef(className = ClassUtil.concatName(packageName, shortClassName), this.instanceDef, this.autoBindingDef);
        if (cd.getComponentName() == null && this.autoNaming != null) {
            cd.setComponentName(this.autoNaming.defineName(packageName, shortClassName));
        }
        annoHandler.appendDI(cd);
        annoHandler.appendAspect(cd);
        annoHandler.appendInitMethod(cd);
        this.getContainer().register(cd);
    }

    protected String[] getTargetPackages() {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < this.getClassPatternSize(); ++i) {
            String packageName = this.getClassPattern(i).getPackageName();
            boolean append = true;
            for (int j = 0; j < result.size(); ++j) {
                String root = (String)result.get(j);
                if (packageName.equals(root)) {
                    append = false;
                    break;
                }
                if (packageName.startsWith(root)) {
                    append = false;
                    break;
                }
                if (!root.startsWith(packageName)) continue;
                result.set(j, packageName);
                append = false;
                break;
            }
            if (!append) continue;
            result.add(packageName);
        }
        return result.toArray(new String[result.size()]);
    }
}

