/*
 * Copyright 2004-2006 H2 Group. Licensed under the H2 License, Version 1.0 (http://h2database.com/html/license.html).
 * Initial Developer: H2 Group
 */
package org.h2.index;

import java.sql.SQLException;

import org.h2.engine.Constants;
import org.h2.message.Message;
import org.h2.result.Row;

/**
 * @author Thomas
 */
public class BtreeCursor implements Cursor {
    private BtreeIndex index;
//    private ObjectArray stack = new ObjectArray();
    private BtreePosition top;
    private Row current;
    private boolean first;
    private Row last;

    BtreeCursor(BtreeIndex index, Row last) {
        this.index = index;
        this.last = last;
        first = true;
    }

    void setPosition(int position) {
        top.position = position;
    }

    void push(BtreePage page, int position) {
        if (Constants.CHECK && (top != null && top.page == page)) {
            throw Message.internal();
        }
        top = new BtreePosition(page, position, top);
//        stack.add(top);
    }

    BtreePosition pop() {
        BtreePosition t = top;
        if (t == null) {
            return null;
        }
        top = top.next;
//        stack.remove(stack.size() - 1);
//        if (stack.size() <= 0) {
//            top = null;
//        } else {
//            top = (BtreePosition) stack.get(stack.size() - 1);
//        }
        return t;
    }

    void setCurrentRow(Row row) {
        this.current = row;
    }
    
    public Row get() {
        return current;
    }

    public boolean next() throws SQLException {
        if (first) {
            first = false;
            return current != null;
        }
        top.page.next(this, top.position);
        if(current != null && last != null) {
            if (index.compareRows(current, last) > 0) {
                current = null;
            }
        }
        return current != null;
    }

}
