/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.types;

import java.util.HashMap;
import java.util.Map;
import org.seasar.extension.jdbc.ValueType;
import org.seasar.extension.jdbc.types.BigDecimalType;
import org.seasar.extension.jdbc.types.BinaryStreamType;
import org.seasar.extension.jdbc.types.BinaryType;
import org.seasar.extension.jdbc.types.BooleanType;
import org.seasar.extension.jdbc.types.CharacterType;
import org.seasar.extension.jdbc.types.DoubleType;
import org.seasar.extension.jdbc.types.FloatType;
import org.seasar.extension.jdbc.types.IntegerType;
import org.seasar.extension.jdbc.types.LongType;
import org.seasar.extension.jdbc.types.ObjectType;
import org.seasar.extension.jdbc.types.ShortType;
import org.seasar.extension.jdbc.types.SqlDateType;
import org.seasar.extension.jdbc.types.StringType;
import org.seasar.extension.jdbc.types.TimeType;
import org.seasar.extension.jdbc.types.TimestampType;

public final class ValueTypes {
    public static final ValueType STRING = new StringType();
    public static final ValueType CHARACTER = new CharacterType();
    public static final ValueType SHORT = new ShortType();
    public static final ValueType INTEGER = new IntegerType();
    public static final ValueType LONG = new LongType();
    public static final ValueType FLOAT = new FloatType();
    public static final ValueType DOUBLE = new DoubleType();
    public static final ValueType BIGDECIMAL = new BigDecimalType();
    public static final ValueType TIME = new TimeType();
    public static final ValueType SQLDATE = new SqlDateType();
    public static final ValueType TIMESTAMP = new TimestampType();
    public static final ValueType BINARY = new BinaryType();
    public static final ValueType BINARY_STREAM = new BinaryStreamType();
    public static final ValueType BOOLEAN = new BooleanType();
    public static final ValueType OBJECT = new ObjectType();
    private static final Class BYTE_ARRAY_CLASS = new byte[0].getClass();
    private static Map types_ = new HashMap();
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$util$Calendar;
    static /* synthetic */ Class class$java$io$InputStream;
    static /* synthetic */ Class class$java$lang$Boolean;

    private ValueTypes() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerValueType(Class clazz, ValueType valueType) {
        Map map = types_;
        synchronized (map) {
            types_.put(clazz, valueType);
        }
    }

    public static ValueType getValueType(Object obj) {
        if (obj == null) {
            return OBJECT;
        }
        return ValueTypes.getValueType(obj.getClass());
    }

    public static ValueType getValueType(Class clazz) {
        for (Class c = clazz; c != null; c = c.getSuperclass()) {
            ValueType valueType = ValueTypes.getValueType0(c);
            if (valueType == null) continue;
            return valueType;
        }
        return OBJECT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ValueType getValueType0(Class clazz) {
        Map map = types_;
        synchronized (map) {
            return (ValueType)types_.get(clazz);
        }
    }

    public static ValueType getValueType(int type) {
        switch (type) {
            case -6: 
            case 5: {
                return ValueTypes.getValueType(class$java$lang$Short == null ? (class$java$lang$Short = ValueTypes.class$("java.lang.Short")) : class$java$lang$Short);
            }
            case 4: {
                return ValueTypes.getValueType(class$java$lang$Integer == null ? (class$java$lang$Integer = ValueTypes.class$("java.lang.Integer")) : class$java$lang$Integer);
            }
            case -5: {
                return ValueTypes.getValueType(class$java$lang$Long == null ? (class$java$lang$Long = ValueTypes.class$("java.lang.Long")) : class$java$lang$Long);
            }
            case 6: 
            case 7: {
                return ValueTypes.getValueType(class$java$lang$Float == null ? (class$java$lang$Float = ValueTypes.class$("java.lang.Float")) : class$java$lang$Float);
            }
            case 8: {
                return ValueTypes.getValueType(class$java$lang$Double == null ? (class$java$lang$Double = ValueTypes.class$("java.lang.Double")) : class$java$lang$Double);
            }
            case 2: 
            case 3: {
                return ValueTypes.getValueType(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = ValueTypes.class$("java.math.BigDecimal")) : class$java$math$BigDecimal);
            }
            case 91: {
                return ValueTypes.getValueType(class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = ValueTypes.class$("java.sql.Timestamp")) : class$java$sql$Timestamp);
            }
            case 92: {
                return ValueTypes.getValueType(class$java$sql$Time == null ? (class$java$sql$Time = ValueTypes.class$("java.sql.Time")) : class$java$sql$Time);
            }
            case 93: {
                return ValueTypes.getValueType(class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = ValueTypes.class$("java.sql.Timestamp")) : class$java$sql$Timestamp);
            }
            case -4: 
            case -3: 
            case -2: {
                return ValueTypes.getValueType(BYTE_ARRAY_CLASS);
            }
            case -1: 
            case 1: 
            case 12: {
                return ValueTypes.getValueType(class$java$lang$String == null ? (class$java$lang$String = ValueTypes.class$("java.lang.String")) : class$java$lang$String);
            }
            case 16: {
                return ValueTypes.getValueType(class$java$lang$Boolean == null ? (class$java$lang$Boolean = ValueTypes.class$("java.lang.Boolean")) : class$java$lang$Boolean);
            }
        }
        return OBJECT;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ValueTypes.registerValueType(class$java$lang$String == null ? (class$java$lang$String = ValueTypes.class$("java.lang.String")) : class$java$lang$String, STRING);
        ValueTypes.registerValueType(Character.TYPE, CHARACTER);
        ValueTypes.registerValueType(class$java$lang$Character == null ? (class$java$lang$Character = ValueTypes.class$("java.lang.Character")) : class$java$lang$Character, CHARACTER);
        ValueTypes.registerValueType(Short.TYPE, SHORT);
        ValueTypes.registerValueType(class$java$lang$Short == null ? (class$java$lang$Short = ValueTypes.class$("java.lang.Short")) : class$java$lang$Short, SHORT);
        ValueTypes.registerValueType(Integer.TYPE, INTEGER);
        ValueTypes.registerValueType(class$java$lang$Integer == null ? (class$java$lang$Integer = ValueTypes.class$("java.lang.Integer")) : class$java$lang$Integer, INTEGER);
        ValueTypes.registerValueType(Long.TYPE, LONG);
        ValueTypes.registerValueType(class$java$lang$Long == null ? (class$java$lang$Long = ValueTypes.class$("java.lang.Long")) : class$java$lang$Long, LONG);
        ValueTypes.registerValueType(Float.TYPE, FLOAT);
        ValueTypes.registerValueType(class$java$lang$Float == null ? (class$java$lang$Float = ValueTypes.class$("java.lang.Float")) : class$java$lang$Float, FLOAT);
        ValueTypes.registerValueType(Double.TYPE, DOUBLE);
        ValueTypes.registerValueType(class$java$lang$Double == null ? (class$java$lang$Double = ValueTypes.class$("java.lang.Double")) : class$java$lang$Double, DOUBLE);
        ValueTypes.registerValueType(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = ValueTypes.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, BIGDECIMAL);
        ValueTypes.registerValueType(class$java$sql$Date == null ? (class$java$sql$Date = ValueTypes.class$("java.sql.Date")) : class$java$sql$Date, SQLDATE);
        ValueTypes.registerValueType(class$java$sql$Time == null ? (class$java$sql$Time = ValueTypes.class$("java.sql.Time")) : class$java$sql$Time, TIME);
        ValueTypes.registerValueType(class$java$util$Date == null ? (class$java$util$Date = ValueTypes.class$("java.util.Date")) : class$java$util$Date, TIMESTAMP);
        ValueTypes.registerValueType(class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = ValueTypes.class$("java.sql.Timestamp")) : class$java$sql$Timestamp, TIMESTAMP);
        ValueTypes.registerValueType(class$java$util$Calendar == null ? (class$java$util$Calendar = ValueTypes.class$("java.util.Calendar")) : class$java$util$Calendar, TIMESTAMP);
        ValueTypes.registerValueType(BYTE_ARRAY_CLASS, BINARY);
        ValueTypes.registerValueType(class$java$io$InputStream == null ? (class$java$io$InputStream = ValueTypes.class$("java.io.InputStream")) : class$java$io$InputStream, BINARY_STREAM);
        ValueTypes.registerValueType(Boolean.TYPE, BOOLEAN);
        ValueTypes.registerValueType(class$java$lang$Boolean == null ? (class$java$lang$Boolean = ValueTypes.class$("java.lang.Boolean")) : class$java$lang$Boolean, BOOLEAN);
    }
}

